/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.Format;
import org.apache.lucene.search.Query;

public abstract class AbstractQueryMaker
implements QueryMaker {
    protected int qnum = 0;
    protected Query[] queries;
    protected Config config;

    public void resetInputs() {
        this.qnum = 0;
    }

    protected abstract Query[] prepareQueries() throws Exception;

    public void setConfig(Config config) throws Exception {
        this.config = config;
        this.queries = this.prepareQueries();
    }

    public String printQueries() {
        String newline = System.getProperty("line.separator");
        StringBuffer sb = new StringBuffer();
        if (this.queries != null) {
            for (int i = 0; i < this.queries.length; ++i) {
                sb.append(i + ". " + Format.simpleName(this.queries[i].getClass()) + " - " + this.queries[i].toString());
                sb.append(newline);
            }
        }
        return sb.toString();
    }

    public Query makeQuery() throws Exception {
        return this.queries[this.nextQnum()];
    }

    protected synchronized int nextQnum() {
        int res = this.qnum;
        this.qnum = (this.qnum + 1) % this.queries.length;
        return res;
    }

    public Query makeQuery(int size) throws Exception {
        throw new Exception(this + ".makeQuery(int size) is not supported!");
    }
}

