/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.text.NumberFormat;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.stats.Points;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.benchmark.byTask.utils.Format;

public abstract class PerfTask
implements Cloneable {
    static final int DEFAULT_LOG_STEP = 1000;
    private PerfRunData runData;
    private String name = Format.simpleName(this.getClass());
    private int depth = 0;
    protected int logStep;
    private int logStepCount = 0;
    private int maxDepthLogStart = 0;
    private boolean disableCounting = false;
    protected String params = null;
    protected static final String NEW_LINE = System.getProperty("line.separator");

    private PerfTask() {
        if (this.name.endsWith("Task")) {
            this.name = this.name.substring(0, this.name.length() - 4);
        }
    }

    private void checkObsoleteSettings(Config config) {
        if (config.get("doc.add.log.step", null) != null) {
            throw new RuntimeException("doc.add.log.step is not supported anymore. Use log.step.AddDoc and refer to CHANGES to read on the recent API changes done to Benchmark's DocMaker and Task-based logging.");
        }
        if (config.get("doc.delete.log.step", null) != null) {
            throw new RuntimeException("doc.delete.log.step is not supported anymore. Use log.step.DeleteDoc and refer to CHANGES to read on the recent API changes done to Benchmark's DocMaker and Task-based logging.");
        }
    }

    public PerfTask(PerfRunData runData) {
        this();
        String taskLogStepAtt;
        this.runData = runData;
        Config config = runData.getConfig();
        this.maxDepthLogStart = config.get("task.max.depth.log", 0);
        String logStepAtt = "log.step";
        String taskName = this.getClass().getName();
        int idx = taskName.lastIndexOf(46);
        int idx2 = taskName.indexOf(36, idx);
        if (idx2 != -1) {
            idx = idx2;
        }
        if (config.get(taskLogStepAtt = "log.step." + taskName.substring(idx + 1, taskName.length() - 4), null) != null) {
            logStepAtt = taskLogStepAtt;
        }
        this.logStep = config.get(logStepAtt, 1000);
        if (this.logStep <= 0) {
            this.logStep = Integer.MAX_VALUE;
        }
        this.checkObsoleteSettings(config);
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public void close() throws Exception {
    }

    public final int runAndMaybeStats(boolean reportStats) throws Exception {
        if (reportStats && this.depth <= this.maxDepthLogStart && !this.shouldNeverLogAtStart()) {
            System.out.println("------------> starting task: " + this.getName());
        }
        if (!reportStats || this.shouldNotRecordStats()) {
            this.setup();
            int count = this.doLogic();
            count = this.disableCounting ? 0 : count;
            this.tearDown();
            return count;
        }
        this.setup();
        Points pnts = this.runData.getPoints();
        TaskStats ts = pnts.markTaskStart(this, this.runData.getConfig().getRoundNumber());
        int count = this.doLogic();
        count = this.disableCounting ? 0 : count;
        pnts.markTaskEnd(ts, count);
        this.tearDown();
        return count;
    }

    public abstract int doLogic() throws Exception;

    public String getName() {
        if (this.params == null) {
            return this.name;
        }
        return this.name + '(' + this.params + ')';
    }

    protected void setName(String name) {
        this.name = name;
    }

    public PerfRunData getRunData() {
        return this.runData;
    }

    public int getDepth() {
        return this.depth;
    }

    public void setDepth(int depth) {
        this.depth = depth;
    }

    String getPadding() {
        char[] c = new char[4 * this.getDepth()];
        for (int i = 0; i < c.length; ++i) {
            c[i] = 32;
        }
        return new String(c);
    }

    public String toString() {
        String padd = this.getPadding();
        StringBuffer sb = new StringBuffer(padd);
        if (this.disableCounting) {
            sb.append('-');
        }
        sb.append(this.getName());
        return sb.toString();
    }

    int getMaxDepthLogStart() {
        return this.maxDepthLogStart;
    }

    protected String getLogMessage(int recsCount) {
        return "processed " + recsCount + " records";
    }

    protected boolean shouldNeverLogAtStart() {
        return false;
    }

    protected boolean shouldNotRecordStats() {
        return false;
    }

    public void setup() throws Exception {
    }

    public void tearDown() throws Exception {
        if (++this.logStepCount % this.logStep == 0) {
            double time = (double)(System.currentTimeMillis() - this.runData.getStartTimeMillis()) / 1000.0;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            System.out.println(nf.format(time) + " sec --> " + Thread.currentThread().getName() + " " + this.getLogMessage(this.logStepCount));
        }
    }

    public boolean supportsParams() {
        return false;
    }

    public void setParams(String params) {
        if (!this.supportsParams()) {
            throw new UnsupportedOperationException(this.getName() + " does not support command line parameters.");
        }
        this.params = params;
    }

    public String getParams() {
        return this.params;
    }

    public boolean isDisableCounting() {
        return this.disableCounting;
    }

    public void setDisableCounting(boolean disableCounting) {
        this.disableCounting = disableCounting;
    }
}

