/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.stats.Report;
import org.apache.lucene.benchmark.byTask.stats.TaskStats;
import org.apache.lucene.benchmark.byTask.tasks.RepSumByPrefTask;

public class RepSumByPrefRoundTask
extends RepSumByPrefTask {
    public RepSumByPrefRoundTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        Report rp = this.reportSumByPrefixRound(this.getRunData().getPoints().taskStats());
        System.out.println();
        System.out.println("------------> Report sum by Prefix (" + this.prefix + ") and Round (" + rp.getSize() + " about " + rp.getReported() + " out of " + rp.getOutOf() + ")");
        System.out.println(rp.getText());
        System.out.println();
        return 0;
    }

    protected Report reportSumByPrefixRound(List taskStats) {
        int reported = 0;
        LinkedHashMap<String, TaskStats> p2 = new LinkedHashMap<String, TaskStats>();
        Iterator it = taskStats.iterator();
        while (it.hasNext()) {
            TaskStats stat1 = (TaskStats)it.next();
            if (stat1.getElapsed() < 0L || !stat1.getTask().getName().startsWith(this.prefix)) continue;
            ++reported;
            String name = stat1.getTask().getName();
            String rname = stat1.getRound() + "." + name;
            TaskStats stat2 = (TaskStats)p2.get(rname);
            if (stat2 == null) {
                try {
                    stat2 = (TaskStats)stat1.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw new RuntimeException(e);
                }
                p2.put(rname, stat2);
                continue;
            }
            stat2.add(stat1);
        }
        return this.genPartialReport(reported, p2, taskStats.size());
    }
}

