/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.QueryMaker;
import org.apache.lucene.benchmark.byTask.tasks.BenchmarkHighlighter;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.highlight.Highlighter;
import org.apache.lucene.search.highlight.InvalidTokenOffsetsException;
import org.apache.lucene.store.Directory;

public abstract class ReadTask
extends PerfTask {
    static final int DEFAULT_SEARCH_NUM_HITS = 10;
    private int numHits;

    public ReadTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws Exception {
        int res = 0;
        boolean closeReader = false;
        IndexReader ir = this.getRunData().getIndexReader();
        if (ir == null) {
            Directory dir = this.getRunData().getDirectory();
            ir = IndexReader.open((Directory)dir);
            closeReader = true;
        }
        if (this.withWarm()) {
            Document doc = null;
            for (int m = 0; m < ir.maxDoc(); ++m) {
                if (ir.isDeleted(m)) continue;
                doc = ir.document(m);
                res += doc == null ? 0 : 1;
            }
        }
        if (this.withSearch()) {
            ++res;
            IndexSearcher searcher = closeReader ? new IndexSearcher(ir) : this.getRunData().getIndexSearcher();
            QueryMaker queryMaker = this.getQueryMaker();
            Query q = queryMaker.makeQuery();
            Sort sort = this.getSort();
            int numHits = this.numHits();
            if (numHits > 0) {
                ScoreDoc[] scoreDocs;
                int traversalSize;
                TopDocs hits;
                if (sort != null) {
                    TopFieldCollector collector = TopFieldCollector.create((Sort)sort, (int)numHits, (boolean)true, (boolean)this.withScore(), (boolean)this.withMaxScore(), (boolean)false);
                    searcher.search(q, (Collector)collector);
                    hits = collector.topDocs();
                } else {
                    hits = searcher.search(q, numHits);
                }
                if (this.withTraverse() && (traversalSize = Math.min((scoreDocs = hits.scoreDocs).length, this.traversalSize())) > 0) {
                    boolean retrieve = this.withRetrieve();
                    int numHighlight = Math.min(this.numToHighlight(), scoreDocs.length);
                    Analyzer analyzer = this.getRunData().getAnalyzer();
                    BenchmarkHighlighter highlighter = null;
                    if (numHighlight > 0) {
                        highlighter = this.getBenchmarkHighlighter(q);
                    }
                    for (int m = 0; m < traversalSize; ++m) {
                        int id = scoreDocs[m].doc;
                        ++res;
                        if (!retrieve) continue;
                        Document document = this.retrieveDoc(ir, id);
                        res += document != null ? 1 : 0;
                        if (numHighlight <= 0 || m >= numHighlight) continue;
                        Collection fieldsToHighlight = this.getFieldsToHighlight(document);
                        Iterator iterator = fieldsToHighlight.iterator();
                        while (iterator.hasNext()) {
                            String field = (String)iterator.next();
                            String text = document.get(field);
                            res += highlighter.doHighlight(ir, id, field, document, analyzer, text);
                        }
                    }
                }
            }
            searcher.close();
        }
        if (closeReader) {
            ir.close();
        }
        return res;
    }

    protected Document retrieveDoc(IndexReader ir, int id) throws IOException {
        return ir.document(id);
    }

    public abstract QueryMaker getQueryMaker();

    public abstract boolean withSearch();

    public abstract boolean withWarm();

    public abstract boolean withTraverse();

    public boolean withScore() {
        return true;
    }

    public boolean withMaxScore() {
        return true;
    }

    public int traversalSize() {
        return Integer.MAX_VALUE;
    }

    public void setup() throws Exception {
        super.setup();
        this.numHits = this.getRunData().getConfig().get("search.num.hits", 10);
    }

    public int numHits() {
        return this.numHits;
    }

    public abstract boolean withRetrieve();

    public int numToHighlight() {
        return 0;
    }

    final Highlighter getHighlighter(Query q) {
        return null;
    }

    protected BenchmarkHighlighter getBenchmarkHighlighter(Query q) {
        return null;
    }

    final int maxNumFragments() {
        return 10;
    }

    final boolean isMergeContiguousFragments() {
        return false;
    }

    final int doHighlight(TokenStream ts, String text, Highlighter highlighter, boolean mergeContiguous, int maxFragments) throws IOException, InvalidTokenOffsetsException {
        return 0;
    }

    protected Sort getSort() {
        return null;
    }

    protected Collection getFieldsToHighlight(Document document) {
        List fieldables = document.getFields();
        HashSet<String> result = new HashSet<String>(fieldables.size());
        Iterator iterator = fieldables.iterator();
        while (iterator.hasNext()) {
            Fieldable fieldable = (Fieldable)iterator.next();
            result.add(fieldable.name());
        }
        return result;
    }
}

