/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.CreateIndexTask;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.apache.lucene.index.IndexCommit;
import org.apache.lucene.index.IndexDeletionPolicy;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.store.Directory;

public class OpenReaderTask
extends PerfTask {
    public static final String USER_DATA = "userData";
    private boolean readOnly = true;
    private String commitUserData = null;

    public OpenReaderTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        Directory dir = this.getRunData().getDirectory();
        Config config = this.getRunData().getConfig();
        IndexReader r = null;
        if (this.commitUserData != null) {
            r = OpenReaderTask.openCommitPoint(this.commitUserData, dir, config, this.readOnly);
        } else {
            IndexDeletionPolicy indexDeletionPolicy = CreateIndexTask.getIndexDeletionPolicy(config);
            r = IndexReader.open((Directory)dir, (IndexDeletionPolicy)indexDeletionPolicy, (boolean)this.readOnly);
        }
        this.getRunData().setIndexReader(r);
        return 1;
    }

    public static IndexReader openCommitPoint(String userData, Directory dir, Config config, boolean readOnly) throws IOException {
        IndexReader r = null;
        Collection commits = IndexReader.listCommits((Directory)dir);
        Iterator i = commits.iterator();
        while (i.hasNext()) {
            IndexCommit ic = (IndexCommit)i.next();
            Map map = ic.getUserData();
            String ud = null;
            if (map != null) {
                ud = (String)map.get(USER_DATA);
            }
            if (ud == null || !ud.equals(userData)) continue;
            IndexDeletionPolicy indexDeletionPolicy = CreateIndexTask.getIndexDeletionPolicy(config);
            r = IndexReader.open((IndexCommit)ic, (IndexDeletionPolicy)indexDeletionPolicy, (boolean)readOnly);
            break;
        }
        if (r == null) {
            throw new IOException("cannot find commitPoint userData:" + userData);
        }
        return r;
    }

    public void setParams(String params) {
        super.setParams(params);
        if (params != null) {
            String[] split = params.split(",");
            if (split.length > 0) {
                this.readOnly = Boolean.valueOf(split[0]);
            }
            if (split.length > 1) {
                this.commitUserData = split[1];
            }
        }
    }

    public boolean supportsParams() {
        return true;
    }
}

