/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.benchmark.byTask.feeds.ContentSource;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.utils.Config;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class EnwikiContentSource
extends ContentSource {
    private static final Map ELEMENTS = new HashMap();
    private static final int TITLE = 0;
    private static final int DATE = 1;
    private static final int BODY = 2;
    private static final int ID = 3;
    private static final int LENGTH = 4;
    private static final int PAGE = 5;
    private static final String[] months = new String[]{"JAN", "FEB", "MAR", "APR", "MAY", "JUN", "JUL", "AUG", "SEP", "OCT", "NOV", "DEC"};
    private File file;
    private boolean keepImages = true;
    private InputStream is;
    private Parser parser = new Parser();

    private static final int getElementType(String elem) {
        Integer val = (Integer)ELEMENTS.get(elem);
        return val == null ? -1 : val;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws IOException {
        EnwikiContentSource enwikiContentSource = this;
        synchronized (enwikiContentSource) {
            if (this.is != null) {
                this.is.close();
                this.is = null;
            }
        }
    }

    public DocData getNextDocData(DocData docData) throws NoMoreDataException, IOException {
        String[] tuple = this.parser.next();
        docData.clear();
        docData.setName(tuple[3]);
        docData.setBody(tuple[2]);
        docData.setDate(tuple[1]);
        docData.setTitle(tuple[0]);
        return docData;
    }

    public void resetInputs() throws IOException {
        super.resetInputs();
        this.is = this.getInputStream(this.file);
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        this.keepImages = config.get("keep.image.only.docs", true);
        String fileName = config.get("docs.file", null);
        if (fileName == null) {
            throw new IllegalArgumentException("docs.file must be set");
        }
        this.file = new File(fileName).getAbsoluteFile();
    }

    static /* synthetic */ InputStream access$300(EnwikiContentSource x0) {
        return x0.is;
    }

    static /* synthetic */ InputStream access$302(EnwikiContentSource x0, InputStream x1) {
        x0.is = x1;
        return x0.is;
    }

    static /* synthetic */ File access$400(EnwikiContentSource x0) {
        return x0.file;
    }

    static {
        ELEMENTS.put("page", new Integer(5));
        ELEMENTS.put("text", new Integer(2));
        ELEMENTS.put("timestamp", new Integer(1));
        ELEMENTS.put("title", new Integer(0));
        ELEMENTS.put("id", new Integer(3));
    }

    private class Parser
    extends DefaultHandler
    implements Runnable {
        private Thread t;
        private boolean threadDone;
        private String[] tuple;
        private NoMoreDataException nmde;
        private StringBuffer contents = new StringBuffer();
        private String title;
        private String body;
        private String time;
        private String id;

        private Parser() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        String[] next() throws NoMoreDataException {
            String[] result;
            if (this.t == null) {
                this.threadDone = false;
                this.t = new Thread(this);
                this.t.setDaemon(true);
                this.t.start();
            }
            Parser parser = this;
            synchronized (parser) {
                while (this.tuple == null && this.nmde == null && !this.threadDone) {
                    try {
                        this.wait();
                    }
                    catch (InterruptedException interruptedException) {}
                }
                if (this.nmde != null) {
                    this.t = null;
                    throw this.nmde;
                }
                if (this.t != null && this.threadDone) {
                    throw new NoMoreDataException();
                }
                result = this.tuple;
                this.tuple = null;
                this.notify();
            }
            return result;
        }

        String time(String original) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(original.substring(8, 10));
            buffer.append('-');
            buffer.append(months[Integer.valueOf(original.substring(5, 7)) - 1]);
            buffer.append('-');
            buffer.append(original.substring(0, 4));
            buffer.append(' ');
            buffer.append(original.substring(11, 19));
            buffer.append(".000");
            return buffer.toString();
        }

        public void characters(char[] ch, int start, int length) {
            this.contents.append(ch, start, length);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void endElement(String namespace, String simple, String qualified) throws SAXException {
            int elemType = EnwikiContentSource.getElementType(qualified);
            switch (elemType) {
                case 5: {
                    if (this.body == null || !EnwikiContentSource.this.keepImages && this.title.startsWith("Image:")) break;
                    String[] tmpTuple = new String[]{this.title.replace('\t', ' '), this.time.replace('\t', ' '), this.body.replaceAll("[\t\n]", " "), this.id};
                    Parser parser = this;
                    synchronized (parser) {
                        while (this.tuple != null) {
                            try {
                                this.wait();
                            }
                            catch (InterruptedException ie) {}
                        }
                        this.tuple = tmpTuple;
                        this.notify();
                        break;
                    }
                }
                case 2: {
                    this.body = this.contents.toString();
                    String startsWith = this.body.substring(0, Math.min(10, this.contents.length())).toLowerCase();
                    if (!startsWith.startsWith("#redirect")) break;
                    this.body = null;
                    break;
                }
                case 1: {
                    this.time = this.time(this.contents.toString());
                    break;
                }
                case 0: {
                    this.title = this.contents.toString();
                    break;
                }
                case 3: {
                    this.id = this.contents.toString();
                    break;
                }
            }
        }

        /*
         * Exception decompiling
         */
        public void run() {
            /*
             * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
             * 
             * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [22[UNCONDITIONALDOLOOP]], but top level block is 11[MONITOR]
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
             *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
             *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
             *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
             *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseInnerClassesPass1(ClassFile.java:923)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1035)
             *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
             *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
             *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
             *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
             *     at org.benf.cfr.reader.Main.main(Main.java:54)
             */
            throw new IllegalStateException("Decompilation failed");
        }

        public void startElement(String namespace, String simple, String qualified, Attributes attributes) {
            int elemType = EnwikiContentSource.getElementType(qualified);
            switch (elemType) {
                case 5: {
                    this.title = null;
                    this.body = null;
                    this.time = null;
                    this.id = null;
                    break;
                }
                case 0: 
                case 1: 
                case 2: 
                case 3: {
                    this.contents.setLength(0);
                    break;
                }
            }
        }
    }
}

