/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.feeds;

import java.util.Properties;
import java.util.Random;
import org.apache.lucene.benchmark.byTask.feeds.DocData;
import org.apache.lucene.benchmark.byTask.feeds.NoMoreDataException;
import org.apache.lucene.benchmark.byTask.feeds.SimpleDocMaker;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class SortableSimpleDocMaker
extends SimpleDocMaker {
    private int sortRange;

    protected DocData getNextDocData() throws NoMoreDataException {
        DocData doc = super.getNextDocData();
        Properties props = new Properties();
        props.put("sort_field", Integer.toString(this.getRandomNumber(0, this.sortRange)));
        doc.setProps(props);
        return doc;
    }

    public void setConfig(Config config) {
        super.setConfig(config);
        this.sortRange = config.get("sort.rng", 20000);
    }

    private int getRandomNumber(int low, int high) {
        Random r = new Random();
        int randInt = Math.abs(r.nextInt()) % (high - low) + low;
        return randInt;
    }
}

