/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.Reader;
import java.text.NumberFormat;
import java.util.List;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.TokenStream;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.feeds.DocMaker;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;

public class ReadTokensTask
extends PerfTask {
    public static final int DEFAULT_DOC_LOG_STEP = 500;
    private int logStep = -1;
    int count = 0;
    int totalTokenCount = 0;
    private Document doc = null;
    Token token = new Token();
    ReusableStringReader stringReader = new ReusableStringReader();

    public ReadTokensTask(PerfRunData runData) {
        super(runData);
    }

    public void setup() throws Exception {
        super.setup();
        DocMaker docMaker = this.getRunData().getDocMaker();
        this.doc = docMaker.makeDocument();
    }

    public void tearDown() throws Exception {
        this.log(++this.count);
        this.doc = null;
        super.tearDown();
    }

    public int doLogic() throws Exception {
        List fields = this.doc.getFields();
        int numField = fields.size();
        Analyzer analyzer = this.getRunData().getAnalyzer();
        int tokenCount = 0;
        for (int i = 0; i < numField; ++i) {
            TokenStream stream;
            Field field = (Field)fields.get(i);
            TokenStream streamValue = field.tokenStreamValue();
            if (streamValue != null) {
                stream = streamValue;
            } else {
                Reader reader;
                Reader readerValue = field.readerValue();
                if (readerValue != null) {
                    reader = readerValue;
                } else {
                    String stringValue = field.stringValue();
                    if (stringValue == null) {
                        throw new IllegalArgumentException("field must have either TokenStream, String or Reader value");
                    }
                    this.stringReader.init(stringValue);
                    reader = this.stringReader;
                }
                stream = analyzer.reusableTokenStream(field.name(), reader);
            }
            stream.reset();
            while (stream.next(this.token) != null) {
                ++tokenCount;
            }
        }
        this.totalTokenCount += tokenCount;
        return tokenCount;
    }

    private void log(int count) {
        if (this.logStep < 0) {
            this.logStep = this.getRunData().getConfig().get("doc.tokenize.log.step", 500);
        }
        if (this.logStep > 0 && count % this.logStep == 0) {
            double seconds = (double)(System.currentTimeMillis() - this.getRunData().getStartTimeMillis()) / 1000.0;
            NumberFormat nf = NumberFormat.getInstance();
            nf.setMaximumFractionDigits(2);
            System.out.println("--> " + nf.format(seconds) + " sec: " + Thread.currentThread().getName() + " processed (add) " + count + " docs" + "; " + this.totalTokenCount + " tokens");
        }
    }

    private static final class ReusableStringReader
    extends Reader {
        int upto;
        int left;
        String s;

        private ReusableStringReader() {
        }

        void init(String s) {
            this.s = s;
            this.left = s.length();
            this.upto = 0;
        }

        public int read(char[] c) {
            return this.read(c, 0, c.length);
        }

        public int read(char[] c, int off, int len) {
            if (this.left > len) {
                this.s.getChars(this.upto, this.upto + len, c, off);
                this.upto += len;
                this.left -= len;
                return len;
            }
            if (0 == this.left) {
                return -1;
            }
            this.s.getChars(this.upto, this.upto + this.left, c, off);
            int r = this.left;
            this.left = 0;
            this.upto = this.s.length();
            return r;
        }

        public void close() {
        }
    }
}

