/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask.tasks;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.tasks.PerfTask;

public class NewAnalyzerTask
extends PerfTask {
    private List analyzerClassNames = new ArrayList();
    private int current;

    public NewAnalyzerTask(PerfRunData runData) {
        super(runData);
    }

    public int doLogic() throws IOException {
        String className = null;
        try {
            if (this.current >= this.analyzerClassNames.size()) {
                this.current = 0;
            }
            if ((className = (String)this.analyzerClassNames.get(this.current++)) == null || className.equals("")) {
                className = "org.apache.lucene.analysis.standard.StandardAnalyzer";
            }
            if (className.indexOf(".") == -1 || className.startsWith("standard.")) {
                className = "org.apache.lucene.analysis." + className;
            }
            this.getRunData().setAnalyzer((Analyzer)Class.forName(className).newInstance());
            System.out.println("Changed Analyzer to: " + className);
        }
        catch (Exception e) {
            throw new RuntimeException("Error creating Analyzer: " + className, e);
        }
        return 1;
    }

    public void setParams(String params) {
        super.setParams(params);
        StringTokenizer tokenizer = new StringTokenizer(params, ",");
        while (tokenizer.hasMoreTokens()) {
            String s = tokenizer.nextToken();
            this.analyzerClassNames.add(s.trim());
        }
    }

    public boolean supportsParams() {
        return true;
    }
}

