/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.benchmark.byTask;

import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import org.apache.lucene.benchmark.byTask.PerfRunData;
import org.apache.lucene.benchmark.byTask.utils.Algorithm;
import org.apache.lucene.benchmark.byTask.utils.Config;

public class Benchmark {
    private PerfRunData runData;
    private Algorithm algorithm;
    private boolean executed;

    public Benchmark(Reader algReader) throws Exception {
        try {
            this.runData = new PerfRunData(new Config(algReader));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new Exception("Error: cannot init PerfRunData!", e);
        }
        try {
            this.algorithm = new Algorithm(this.runData);
        }
        catch (Exception e) {
            throw new Exception("Error: cannot understand algorithm!", e);
        }
    }

    public synchronized void execute() throws Exception {
        if (this.executed) {
            throw new IllegalStateException("Benchmark was already executed");
        }
        this.executed = true;
        this.algorithm.execute();
    }

    public static void main(String[] args) {
        File algFile;
        if (args.length < 1) {
            System.err.println("Usage: java Benchmark <algorithm file>");
            System.exit(1);
        }
        if (!((algFile = new File(args[0])).exists() && algFile.isFile() && algFile.canRead())) {
            System.err.println("cannot find/read algorithm file: " + algFile.getAbsolutePath());
            System.exit(1);
        }
        System.out.println("Running algorithm from: " + algFile.getAbsolutePath());
        Benchmark benchmark = null;
        try {
            benchmark = new Benchmark(new FileReader(algFile));
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.out.println("------------> algorithm:");
        System.out.println(benchmark.getAlgorithm().toString());
        try {
            benchmark.execute();
        }
        catch (Exception e) {
            System.err.println("Error: cannot execute the algorithm! " + e.getMessage());
            e.printStackTrace();
        }
        System.out.println("####################");
        System.out.println("###  D O N E !!! ###");
        System.out.println("####################");
    }

    public Algorithm getAlgorithm() {
        return this.algorithm;
    }

    public PerfRunData getRunData() {
        return this.runData;
    }
}

