/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.db;

import java.io.IOException;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.db.Block;
import org.apache.lucene.store.db.DbDirectory;
import org.apache.lucene.store.db.File;

public class DbIndexInput
extends IndexInput {
    protected long position = 0L;
    protected long length = 0L;
    protected DbDirectory directory;
    protected Block block;
    protected File file;

    protected DbIndexInput(DbDirectory directory, String name) throws IOException {
        this.directory = directory;
        this.file = new File(name);
        if (!this.file.exists(directory)) {
            throw new IOException("File does not exist: " + name);
        }
        this.length = this.file.getLength();
        this.block = new Block(this.file);
        this.block.get(directory);
    }

    public Object clone() {
        try {
            DbIndexInput clone = (DbIndexInput)((Object)super.clone());
            clone.block = new Block(this.file);
            clone.block.seek(this.position);
            clone.block.get(this.directory);
            return clone;
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
    }

    public void close() throws IOException {
    }

    public long length() {
        return this.length;
    }

    public byte readByte() throws IOException {
        if (this.position + 1L > this.length) {
            throw new IOException("Reading past end of file");
        }
        int blockPos = (int)(this.position++ & 0x3FFFL);
        byte b = this.block.getData()[blockPos];
        if (blockPos + 1 == 16384) {
            this.block.seek(this.position);
            this.block.get(this.directory);
        }
        return b;
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        if (this.position + (long)len > this.length) {
            throw new IOException("Reading past end of file");
        }
        int blockPos = (int)(this.position & 0x3FFFL);
        while (blockPos + len >= 16384) {
            int blockLen = 16384 - blockPos;
            System.arraycopy(this.block.getData(), blockPos, b, offset, blockLen);
            len -= blockLen;
            offset += blockLen;
            this.position += (long)blockLen;
            this.block.seek(this.position);
            this.block.get(this.directory);
            blockPos = 0;
        }
        if (len > 0) {
            System.arraycopy(this.block.getData(), blockPos, b, offset, len);
            this.position += (long)len;
        }
    }

    public void seek(long pos) throws IOException {
        if (pos > this.length) {
            throw new IOException("seeking past end of file");
        }
        if (pos >>> 14 != this.position >>> 14) {
            this.block.seek(pos);
            this.block.get(this.directory);
        }
        this.position = pos;
    }

    public long getFilePointer() {
        return this.position;
    }
}

