/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store.db;

import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.DbHandleExtractor;
import com.sleepycat.db.Transaction;
import com.sleepycat.db.internal.Db;
import com.sleepycat.db.internal.DbTxn;
import com.sleepycat.db.internal.Dbc;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.Lock;
import org.apache.lucene.store.db.DbIndexInput;
import org.apache.lucene.store.db.DbIndexOutput;
import org.apache.lucene.store.db.DbLock;
import org.apache.lucene.store.db.File;

public class DbDirectory
extends Directory {
    protected Set openFiles = Collections.synchronizedSet(new HashSet());
    protected Db files;
    protected Db blocks;
    protected DbTxn txn;
    protected int flags;

    public DbDirectory(DbTxn txn, Db files, Db blocks, int flags) {
        this.txn = txn;
        this.files = files;
        this.blocks = blocks;
        this.flags = flags;
    }

    public DbDirectory(Transaction txn, Database files, Database blocks, int flags) {
        this.txn = txn != null ? DbHandleExtractor.getDbTxn(txn) : null;
        this.files = DbHandleExtractor.getDb(files);
        this.blocks = DbHandleExtractor.getDb(blocks);
        this.flags = flags;
    }

    public DbDirectory(Transaction txn, Database files, Database blocks) {
        this(txn, files, blocks, 0);
    }

    public void close() throws IOException {
        this.flush();
    }

    public void flush() throws IOException {
        Iterator iterator = this.openFiles.iterator();
        while (iterator.hasNext()) {
            ((IndexOutput)iterator.next()).flush();
        }
    }

    public IndexOutput createOutput(String name) throws IOException {
        return new DbIndexOutput(this, name, true);
    }

    public void deleteFile(String name) throws IOException {
        new File(name).delete(this);
    }

    public boolean fileExists(String name) throws IOException {
        return new File(name).exists(this);
    }

    public long fileLength(String name) throws IOException {
        File file = new File(name);
        if (file.exists(this)) {
            return file.getLength();
        }
        throw new IOException("File does not exist: " + name);
    }

    public long fileModified(String name) throws IOException {
        File file = new File(name);
        if (file.exists(this)) {
            return file.getTimeModified();
        }
        throw new IOException("File does not exist: " + name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String[] list() throws IOException {
        Dbc cursor = null;
        ArrayList<String> list = new ArrayList<String>();
        try {
            try {
                DatabaseEntry key = new DatabaseEntry(new byte[0]);
                DatabaseEntry data = new DatabaseEntry((byte[])null);
                data.setPartial(true);
                cursor = this.files.cursor(this.txn, this.flags);
                if (cursor.get(key, data, 0x1E | this.flags) != -30989) {
                    ByteArrayInputStream buffer = new ByteArrayInputStream(key.getData());
                    DataInputStream in = new DataInputStream(buffer);
                    String name = in.readUTF();
                    in.close();
                    list.add(name);
                    while (cursor.get(key, data, 0x12 | this.flags) != -30989) {
                        buffer = new ByteArrayInputStream(key.getData());
                        in = new DataInputStream(buffer);
                        name = in.readUTF();
                        in.close();
                        list.add(name);
                    }
                }
            }
            finally {
                if (cursor != null) {
                    cursor.close();
                }
            }
        }
        catch (DatabaseException e) {
            throw new IOException(e.getMessage());
        }
        return list.toArray(new String[list.size()]);
    }

    public IndexInput openInput(String name) throws IOException {
        return new DbIndexInput(this, name);
    }

    public Lock makeLock(String name) {
        return new DbLock();
    }

    public void renameFile(String from, String to) throws IOException {
        new File(from).rename(this, to);
    }

    public void touchFile(String name) throws IOException {
        File file = new File(name);
        long length = 0L;
        if (file.exists(this)) {
            length = file.getLength();
        }
        file.modify(this, length, System.currentTimeMillis());
    }

    public void setTransaction(Transaction txn) {
        this.setTransaction(txn != null ? DbHandleExtractor.getDbTxn(txn) : null);
    }

    public void setTransaction(DbTxn txn) {
        this.txn = txn;
    }
}

