/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.backward_codecs.store;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.RandomAccessInput;

final class EndiannessReverserIndexInput
extends IndexInput {
    final IndexInput in;

    EndiannessReverserIndexInput(IndexInput in) {
        super("Endianness reverser Index Input wrapper");
        this.in = in;
    }

    public byte readByte() throws IOException {
        return this.in.readByte();
    }

    public void readBytes(byte[] b, int offset, int len) throws IOException {
        this.in.readBytes(b, offset, len);
    }

    public void readBytes(byte[] b, int offset, int len, boolean useBuffer) throws IOException {
        this.in.readBytes(b, offset, len, useBuffer);
    }

    public short readShort() throws IOException {
        return Short.reverseBytes(this.in.readShort());
    }

    public int readInt() throws IOException {
        return Integer.reverseBytes(this.in.readInt());
    }

    public int readVInt() throws IOException {
        return this.in.readVInt();
    }

    public int readZInt() throws IOException {
        return this.in.readZInt();
    }

    public long readLong() throws IOException {
        return Long.reverseBytes(this.in.readLong());
    }

    public void readLongs(long[] dst, int offset, int length) throws IOException {
        this.in.readLongs(dst, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = Long.reverseBytes(dst[offset + i]);
        }
    }

    public void readFloats(float[] dst, int offset, int length) throws IOException {
        this.in.readFloats(dst, offset, length);
        for (int i = 0; i < length; ++i) {
            dst[offset + i] = Float.intBitsToFloat(Integer.reverseBytes(Float.floatToRawIntBits(dst[offset + i])));
        }
    }

    public long readVLong() throws IOException {
        return this.in.readVLong();
    }

    public long readZLong() throws IOException {
        return this.in.readZLong();
    }

    public String readString() throws IOException {
        return this.in.readString();
    }

    public IndexInput clone() {
        return new EndiannessReverserIndexInput(this.in.clone());
    }

    public IndexInput slice(String sliceDescription, long offset, long length) throws IOException {
        return new EndiannessReverserIndexInput(this.in.slice(sliceDescription, offset, length));
    }

    public Map<String, String> readMapOfStrings() throws IOException {
        return this.in.readMapOfStrings();
    }

    public Set<String> readSetOfStrings() throws IOException {
        return this.in.readSetOfStrings();
    }

    public void skipBytes(long numBytes) throws IOException {
        this.in.skipBytes(numBytes);
    }

    public void close() throws IOException {
        this.in.close();
    }

    public long getFilePointer() {
        return this.in.getFilePointer();
    }

    public void seek(long pos) throws IOException {
        this.in.seek(pos);
    }

    public long length() {
        return this.in.length();
    }

    public String toString() {
        return this.in.toString();
    }

    public RandomAccessInput randomAccessSlice(long offset, long length) throws IOException {
        return new EndiannessReverserRandomAccessInput(this.in.randomAccessSlice(offset, length));
    }

    public static class EndiannessReverserRandomAccessInput
    implements RandomAccessInput {
        private final RandomAccessInput in;

        public EndiannessReverserRandomAccessInput(RandomAccessInput in) {
            this.in = in;
        }

        public byte readByte(long pos) throws IOException {
            return this.in.readByte(pos);
        }

        public short readShort(long pos) throws IOException {
            return Short.reverseBytes(this.in.readShort(pos));
        }

        public int readInt(long pos) throws IOException {
            return Integer.reverseBytes(this.in.readInt(pos));
        }

        public long readLong(long pos) throws IOException {
            return Long.reverseBytes(this.in.readLong(pos));
        }
    }
}

