/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene46;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.UndeadNormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.ChecksumIndexInput;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.DataOutput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;

@Deprecated
public final class Lucene46FieldInfosFormat
extends FieldInfosFormat {
    static final String EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene46FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_CHECKSUM = 1;
    static final int FORMAT_SORTED_NUMERIC = 2;
    static final int FORMAT_CURRENT = 2;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_OFFSETS_IN_POSTINGS = 4;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;

    public FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)EXTENSION);
        try (ChecksumIndexInput input = directory.openChecksumInput(fileName, context);){
            int codecVersion = CodecUtil.checkHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)2);
            int size = input.readVInt();
            FieldInfo[] infos = new FieldInfo[size];
            for (int i = 0; i < size; ++i) {
                boolean storePayloads;
                String name = input.readString();
                int fieldNumber = input.readVInt();
                if (fieldNumber < 0) {
                    throw new CorruptIndexException("invalid field number for field: " + name + ", fieldNumber=" + fieldNumber, (DataInput)input);
                }
                byte bits = input.readByte();
                boolean isIndexed = (bits & 1) != 0;
                boolean storeTermVector = (bits & 2) != 0;
                boolean omitNorms = (bits & 0x10) != 0;
                boolean bl = storePayloads = (bits & 0x20) != 0;
                IndexOptions indexOptions = !isIndexed ? IndexOptions.NONE : ((bits & 0x40) != 0 ? IndexOptions.DOCS : ((bits & 0xFFFFFF80) != 0 ? IndexOptions.DOCS_AND_FREQS : ((bits & 4) != 0 ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS)));
                byte val = input.readByte();
                DocValuesType docValuesType = Lucene46FieldInfosFormat.getDocValuesType((IndexInput)input, (byte)(val & 0xF));
                DocValuesType normsType = Lucene46FieldInfosFormat.getDocValuesType((IndexInput)input, (byte)(val >>> 4 & 0xF));
                long dvGen = input.readLong();
                Map attributes = input.readStringStringMap();
                if (isIndexed && !omitNorms && normsType == DocValuesType.NONE) {
                    UndeadNormsProducer.setUndead(attributes);
                }
                infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, docValuesType, dvGen, Collections.unmodifiableMap(attributes));
            }
            if (codecVersion >= 1) {
                CodecUtil.checkFooter((ChecksumIndexInput)input);
            } else {
                CodecUtil.checkEOF((IndexInput)input);
            }
            FieldInfos fieldInfos = new FieldInfos(infos);
            return fieldInfos;
        }
    }

    private static DocValuesType getDocValuesType(IndexInput input, byte b) throws IOException {
        if (b == 0) {
            return DocValuesType.NONE;
        }
        if (b == 1) {
            return DocValuesType.NUMERIC;
        }
        if (b == 2) {
            return DocValuesType.BINARY;
        }
        if (b == 3) {
            return DocValuesType.SORTED;
        }
        if (b == 4) {
            return DocValuesType.SORTED_SET;
        }
        if (b == 5) {
            return DocValuesType.SORTED_NUMERIC;
        }
        throw new CorruptIndexException("invalid docvalues byte: " + b, (DataInput)input);
    }

    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)segmentSuffix, (String)EXTENSION);
        try (IndexOutput output = directory.createOutput(fileName, context);){
            CodecUtil.writeHeader((DataOutput)output, (String)CODEC_NAME, (int)2);
            output.writeVInt(infos.size());
            for (FieldInfo fi : infos) {
                IndexOptions indexOptions = fi.getIndexOptions();
                byte bits = 0;
                if (fi.hasVectors()) {
                    bits = (byte)(bits | 2);
                }
                if (fi.omitsNorms()) {
                    bits = (byte)(bits | 0x10);
                }
                if (fi.hasPayloads()) {
                    bits = (byte)(bits | 0x20);
                }
                if (fi.getIndexOptions() != IndexOptions.NONE) {
                    bits = (byte)(bits | 1);
                    assert (indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) >= 0 || !fi.hasPayloads());
                    if (indexOptions == IndexOptions.DOCS) {
                        bits = (byte)(bits | 0x40);
                    } else if (indexOptions == IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS) {
                        bits = (byte)(bits | 4);
                    } else if (indexOptions == IndexOptions.DOCS_AND_FREQS) {
                        bits = (byte)(bits | 0xFFFFFF80);
                    }
                }
                output.writeString(fi.name);
                output.writeVInt(fi.number);
                output.writeByte(bits);
                byte dv = Lucene46FieldInfosFormat.docValuesByte(fi.getDocValuesType());
                byte nrm = Lucene46FieldInfosFormat.docValuesByte(fi.hasNorms() ? DocValuesType.NUMERIC : DocValuesType.NONE);
                assert ((dv & 0xFFFFFFF0) == 0 && (nrm & 0xFFFFFFF0) == 0);
                byte val = (byte)(0xFF & (nrm << 4 | dv));
                output.writeByte(val);
                output.writeLong(fi.getDocValuesGen());
                output.writeStringStringMap(fi.attributes());
            }
            CodecUtil.writeFooter((IndexOutput)output);
        }
    }

    private static byte docValuesByte(DocValuesType type) {
        assert (type != null);
        if (type == DocValuesType.NONE) {
            return 0;
        }
        if (type == DocValuesType.NUMERIC) {
            return 1;
        }
        if (type == DocValuesType.BINARY) {
            return 2;
        }
        if (type == DocValuesType.SORTED) {
            return 3;
        }
        if (type == DocValuesType.SORTED_SET) {
            return 4;
        }
        if (type == DocValuesType.SORTED_NUMERIC) {
            return 5;
        }
        throw new AssertionError();
    }
}

