/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.FieldInfosFormat;
import org.apache.lucene.codecs.UndeadNormsProducer;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.DocValuesType;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.IOUtils;

@Deprecated
public class Lucene40FieldInfosFormat
extends FieldInfosFormat {
    static final String LEGACY_DV_TYPE_KEY = Lucene40FieldInfosFormat.class.getSimpleName() + ".dvtype";
    static final String LEGACY_NORM_TYPE_KEY = Lucene40FieldInfosFormat.class.getSimpleName() + ".normtype";
    static final String FIELD_INFOS_EXTENSION = "fnm";
    static final String CODEC_NAME = "Lucene40FieldInfos";
    static final int FORMAT_START = 0;
    static final int FORMAT_CURRENT = 0;
    static final byte IS_INDEXED = 1;
    static final byte STORE_TERMVECTOR = 2;
    static final byte STORE_OFFSETS_IN_POSTINGS = 4;
    static final byte OMIT_NORMS = 16;
    static final byte STORE_PAYLOADS = 32;
    static final byte OMIT_TERM_FREQ_AND_POSITIONS = 64;
    static final byte OMIT_POSITIONS = -128;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final FieldInfos read(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, IOContext iocontext) throws IOException {
        FieldInfos fieldInfos;
        block11: {
            IndexInput input;
            block10: {
                String fileName = IndexFileNames.segmentFileName((String)segmentInfo.name, (String)"", (String)FIELD_INFOS_EXTENSION);
                input = directory.openInput(fileName, iocontext);
                boolean success = false;
                try {
                    CodecUtil.checkHeader((DataInput)input, (String)CODEC_NAME, (int)0, (int)0);
                    int size = input.readVInt();
                    FieldInfo[] infos = new FieldInfo[size];
                    for (int i = 0; i < size; ++i) {
                        boolean storePayloads;
                        String name = input.readString();
                        int fieldNumber = input.readVInt();
                        byte bits = input.readByte();
                        boolean isIndexed = (bits & 1) != 0;
                        boolean storeTermVector = (bits & 2) != 0;
                        boolean omitNorms = (bits & 0x10) != 0;
                        boolean bl = storePayloads = (bits & 0x20) != 0;
                        IndexOptions indexOptions = !isIndexed ? IndexOptions.NONE : ((bits & 0x40) != 0 ? IndexOptions.DOCS : ((bits & 0xFFFFFF80) != 0 ? IndexOptions.DOCS_AND_FREQS : ((bits & 4) != 0 ? IndexOptions.DOCS_AND_FREQS_AND_POSITIONS_AND_OFFSETS : IndexOptions.DOCS_AND_FREQS_AND_POSITIONS)));
                        if (isIndexed && indexOptions.compareTo((Enum)IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                            storePayloads = false;
                        }
                        byte val = input.readByte();
                        LegacyDocValuesType oldValuesType = Lucene40FieldInfosFormat.getDocValuesType((byte)(val & 0xF));
                        LegacyDocValuesType oldNormsType = Lucene40FieldInfosFormat.getDocValuesType((byte)(val >>> 4 & 0xF));
                        Map attributes = input.readStringStringMap();
                        if (oldValuesType.mapping != DocValuesType.NONE) {
                            attributes.put(LEGACY_DV_TYPE_KEY, oldValuesType.name());
                        }
                        if (oldNormsType.mapping != DocValuesType.NONE) {
                            if (oldNormsType.mapping != DocValuesType.NUMERIC) {
                                throw new CorruptIndexException("invalid norm type: " + (Object)((Object)oldNormsType), (DataInput)input);
                            }
                            attributes.put(LEGACY_NORM_TYPE_KEY, oldNormsType.name());
                        }
                        if (isIndexed && !omitNorms && oldNormsType.mapping == DocValuesType.NONE) {
                            UndeadNormsProducer.setUndead(attributes);
                        }
                        infos[i] = new FieldInfo(name, fieldNumber, storeTermVector, omitNorms, storePayloads, indexOptions, oldValuesType.mapping, -1L, Collections.unmodifiableMap(attributes));
                    }
                    CodecUtil.checkEOF((IndexInput)input);
                    FieldInfos fieldInfos2 = new FieldInfos(infos);
                    success = true;
                    fieldInfos = fieldInfos2;
                    if (!success) break block10;
                }
                catch (Throwable throwable) {
                    if (success) {
                        input.close();
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
                    }
                    throw throwable;
                }
                input.close();
                break block11;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
        }
        return fieldInfos;
    }

    private static LegacyDocValuesType getDocValuesType(byte b) {
        return LegacyDocValuesType.values()[b];
    }

    public void write(Directory directory, SegmentInfo segmentInfo, String segmentSuffix, FieldInfos infos, IOContext context) throws IOException {
        throw new UnsupportedOperationException("this codec can only be used for reading");
    }

    static enum LegacyDocValuesType {
        NONE(DocValuesType.NONE),
        VAR_INTS(DocValuesType.NUMERIC),
        FLOAT_32(DocValuesType.NUMERIC),
        FLOAT_64(DocValuesType.NUMERIC),
        BYTES_FIXED_STRAIGHT(DocValuesType.BINARY),
        BYTES_FIXED_DEREF(DocValuesType.BINARY),
        BYTES_VAR_STRAIGHT(DocValuesType.BINARY),
        BYTES_VAR_DEREF(DocValuesType.BINARY),
        FIXED_INTS_16(DocValuesType.NUMERIC),
        FIXED_INTS_32(DocValuesType.NUMERIC),
        FIXED_INTS_64(DocValuesType.NUMERIC),
        FIXED_INTS_8(DocValuesType.NUMERIC),
        BYTES_FIXED_SORTED(DocValuesType.SORTED),
        BYTES_VAR_SORTED(DocValuesType.SORTED);

        final DocValuesType mapping;

        private LegacyDocValuesType(DocValuesType mapping) {
            this.mapping = mapping;
        }
    }
}

