/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.codecs.lucene40;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.codecs.CodecUtil;
import org.apache.lucene.codecs.DocValuesProducer;
import org.apache.lucene.codecs.lucene40.Lucene40CompoundReader;
import org.apache.lucene.codecs.lucene40.Lucene40FieldInfosFormat;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.CorruptIndexException;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.IndexFileNames;
import org.apache.lucene.index.NumericDocValues;
import org.apache.lucene.index.SegmentReadState;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.index.SortedNumericDocValues;
import org.apache.lucene.index.SortedSetDocValues;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.util.Accountable;
import org.apache.lucene.util.Accountables;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.PagedBytes;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.packed.PackedInts;

@Deprecated
final class Lucene40DocValuesReader
extends DocValuesProducer {
    private final Directory dir;
    private final SegmentReadState state;
    private final String legacyKey;
    private static final String segmentSuffix = "dv";
    private final Map<String, NumericDocValues> numericInstances = new HashMap<String, NumericDocValues>();
    private final Map<String, BinaryDocValues> binaryInstances = new HashMap<String, BinaryDocValues>();
    private final Map<String, SortedDocValues> sortedInstances = new HashMap<String, SortedDocValues>();
    private final Map<String, Accountable> instanceInfo = new HashMap<String, Accountable>();
    private final AtomicLong ramBytesUsed;
    private final boolean merging;

    Lucene40DocValuesReader(Lucene40DocValuesReader original) throws IOException {
        assert (Thread.holdsLock((Object)original));
        this.dir = original.dir;
        this.state = original.state;
        this.legacyKey = original.legacyKey;
        this.numericInstances.putAll(original.numericInstances);
        this.binaryInstances.putAll(original.binaryInstances);
        this.sortedInstances.putAll(original.sortedInstances);
        this.instanceInfo.putAll(original.instanceInfo);
        this.ramBytesUsed = new AtomicLong(original.ramBytesUsed.get());
        this.merging = true;
    }

    Lucene40DocValuesReader(SegmentReadState state, String filename, String legacyKey) throws IOException {
        this.state = state;
        this.legacyKey = legacyKey;
        this.dir = new Lucene40CompoundReader(state.directory, filename, state.context, false);
        this.ramBytesUsed = new AtomicLong(RamUsageEstimator.shallowSizeOf(((Object)((Object)this)).getClass()));
        this.merging = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized NumericDocValues getNumeric(FieldInfo field) throws IOException {
        NumericDocValues instance;
        block15: {
            block16: {
                IndexInput input;
                block14: {
                    instance = this.numericInstances.get(field.name);
                    if (instance != null) break block15;
                    String fileName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                    input = this.dir.openInput(fileName, this.state.context);
                    boolean success = false;
                    try {
                        switch (Lucene40FieldInfosFormat.LegacyDocValuesType.valueOf(field.getAttribute(this.legacyKey))) {
                            case VAR_INTS: {
                                instance = this.loadVarIntsField(field, input);
                                break;
                            }
                            case FIXED_INTS_8: {
                                instance = this.loadByteField(field, input);
                                break;
                            }
                            case FIXED_INTS_16: {
                                instance = this.loadShortField(field, input);
                                break;
                            }
                            case FIXED_INTS_32: {
                                instance = this.loadIntField(field, input);
                                break;
                            }
                            case FIXED_INTS_64: {
                                instance = this.loadLongField(field, input);
                                break;
                            }
                            case FLOAT_32: {
                                instance = this.loadFloatField(field, input);
                                break;
                            }
                            case FLOAT_64: {
                                instance = this.loadDoubleField(field, input);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        CodecUtil.checkEOF((IndexInput)input);
                        success = true;
                        if (!success) break block14;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{input});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
                        }
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{input});
                    break block16;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
            }
            if (!this.merging) {
                this.numericInstances.put(field.name, instance);
            }
        }
        return instance;
    }

    private NumericDocValues loadVarIntsField(FieldInfo field, IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"PackedInts", (int)0, (int)0);
        byte header = input.readByte();
        if (header == 1) {
            int maxDoc = this.state.segmentInfo.getDocCount();
            final long[] values = new long[maxDoc];
            for (int i = 0; i < values.length; ++i) {
                values[i] = input.readLong();
            }
            long bytesUsed = RamUsageEstimator.sizeOf((long[])values);
            if (!this.merging) {
                this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"long array", (long)bytesUsed));
                this.ramBytesUsed.addAndGet(bytesUsed);
            }
            return new NumericDocValues(){

                public long get(int docID) {
                    return values[docID];
                }
            };
        }
        if (header == 0) {
            final long minValue = input.readLong();
            final long defaultValue = input.readLong();
            final PackedInts.Reader reader = PackedInts.getReader((DataInput)input);
            if (!this.merging) {
                this.instanceInfo.put(field.name, (Accountable)reader);
                this.ramBytesUsed.addAndGet(reader.ramBytesUsed());
            }
            return new NumericDocValues(){

                public long get(int docID) {
                    long value = reader.get(docID);
                    if (value == defaultValue) {
                        return 0L;
                    }
                    return minValue + value;
                }
            };
        }
        throw new CorruptIndexException("invalid VAR_INTS header byte: " + header, (DataInput)input);
    }

    private NumericDocValues loadByteField(FieldInfo field, IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"Ints", (int)0, (int)0);
        int valueSize = input.readInt();
        if (valueSize != 1) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, (DataInput)input);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final byte[] values = new byte[maxDoc];
        input.readBytes(values, 0, values.length);
        long bytesUsed = RamUsageEstimator.sizeOf((byte[])values);
        if (!this.merging) {
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"byte array", (long)bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            public long get(int docID) {
                return values[docID];
            }
        };
    }

    private NumericDocValues loadShortField(FieldInfo field, IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"Ints", (int)0, (int)0);
        int valueSize = input.readInt();
        if (valueSize != 2) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, (DataInput)input);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final short[] values = new short[maxDoc];
        for (int i = 0; i < values.length; ++i) {
            values[i] = input.readShort();
        }
        long bytesUsed = RamUsageEstimator.sizeOf((short[])values);
        if (!this.merging) {
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"short array", (long)bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            public long get(int docID) {
                return values[docID];
            }
        };
    }

    private NumericDocValues loadIntField(FieldInfo field, IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"Ints", (int)0, (int)0);
        int valueSize = input.readInt();
        if (valueSize != 4) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, (DataInput)input);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final int[] values = new int[maxDoc];
        for (int i = 0; i < values.length; ++i) {
            values[i] = input.readInt();
        }
        long bytesUsed = RamUsageEstimator.sizeOf((int[])values);
        if (!this.merging) {
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"int array", (long)bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            public long get(int docID) {
                return values[docID];
            }
        };
    }

    private NumericDocValues loadLongField(FieldInfo field, IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"Ints", (int)0, (int)0);
        int valueSize = input.readInt();
        if (valueSize != 8) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, (DataInput)input);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final long[] values = new long[maxDoc];
        for (int i = 0; i < values.length; ++i) {
            values[i] = input.readLong();
        }
        long bytesUsed = RamUsageEstimator.sizeOf((long[])values);
        if (!this.merging) {
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"long array", (long)bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            public long get(int docID) {
                return values[docID];
            }
        };
    }

    private NumericDocValues loadFloatField(FieldInfo field, IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"Floats", (int)0, (int)0);
        int valueSize = input.readInt();
        if (valueSize != 4) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, (DataInput)input);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final int[] values = new int[maxDoc];
        for (int i = 0; i < values.length; ++i) {
            values[i] = input.readInt();
        }
        long bytesUsed = RamUsageEstimator.sizeOf((int[])values);
        if (!this.merging) {
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"float array", (long)bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            public long get(int docID) {
                return values[docID];
            }
        };
    }

    private NumericDocValues loadDoubleField(FieldInfo field, IndexInput input) throws IOException {
        CodecUtil.checkHeader((DataInput)input, (String)"Floats", (int)0, (int)0);
        int valueSize = input.readInt();
        if (valueSize != 8) {
            throw new CorruptIndexException("invalid valueSize: " + valueSize, (DataInput)input);
        }
        int maxDoc = this.state.segmentInfo.getDocCount();
        final long[] values = new long[maxDoc];
        for (int i = 0; i < values.length; ++i) {
            values[i] = input.readLong();
        }
        long bytesUsed = RamUsageEstimator.sizeOf((long[])values);
        if (!this.merging) {
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"double array", (long)bytesUsed));
            this.ramBytesUsed.addAndGet(bytesUsed);
        }
        return new NumericDocValues(){

            public long get(int docID) {
                return values[docID];
            }
        };
    }

    public synchronized BinaryDocValues getBinary(FieldInfo field) throws IOException {
        BinaryDocValues instance = this.binaryInstances.get(field.name);
        if (instance == null) {
            switch (Lucene40FieldInfosFormat.LegacyDocValuesType.valueOf(field.getAttribute(this.legacyKey))) {
                case BYTES_FIXED_STRAIGHT: {
                    instance = this.loadBytesFixedStraight(field);
                    break;
                }
                case BYTES_VAR_STRAIGHT: {
                    instance = this.loadBytesVarStraight(field);
                    break;
                }
                case BYTES_FIXED_DEREF: {
                    instance = this.loadBytesFixedDeref(field);
                    break;
                }
                case BYTES_VAR_DEREF: {
                    instance = this.loadBytesVarDeref(field);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            if (!this.merging) {
                this.binaryInstances.put(field.name, instance);
            }
        }
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesFixedStraight(FieldInfo field) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput input;
            block5: {
                String fileName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                input = this.dir.openInput(fileName, this.state.context);
                boolean success = false;
                try {
                    CodecUtil.checkHeader((DataInput)input, (String)"FixedStraightBytes", (int)0, (int)0);
                    final int fixedLength = input.readInt();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(input, (long)fixedLength * (long)this.state.segmentInfo.getDocCount());
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    CodecUtil.checkEOF((IndexInput)input);
                    success = true;
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesReader.ramBytesUsed());
                        this.instanceInfo.put(field.name, (Accountable)bytesReader);
                    }
                    binaryDocValues = new BinaryDocValues(){

                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            bytesReader.fillSlice(term, (long)fixedLength * (long)docID, fixedLength);
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{input});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{input});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{input});
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesVarStraight(FieldInfo field) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput index;
            IndexInput data;
            block5: {
                String dataName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                String indexName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"idx");
                data = null;
                index = null;
                boolean success = false;
                try {
                    data = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader((DataInput)data, (String)"VarStraightBytesDat", (int)0, (int)0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader((DataInput)index, (String)"VarStraightBytesIdx", (int)0, (int)0);
                    long totalBytes = index.readVLong();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(data, totalBytes);
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader((DataInput)index);
                    CodecUtil.checkEOF((IndexInput)data);
                    CodecUtil.checkEOF((IndexInput)index);
                    success = true;
                    long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesUsed);
                        this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"variable straight", (long)bytesUsed));
                    }
                    binaryDocValues = new BinaryDocValues(){

                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            long startAddress = reader.get(docID);
                            long endAddress = reader.get(docID + 1);
                            bytesReader.fillSlice(term, startAddress, (int)(endAddress - startAddress));
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{data, index});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{data, index});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesFixedDeref(FieldInfo field) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput index;
            IndexInput data;
            block5: {
                String dataName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                String indexName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"idx");
                data = null;
                index = null;
                boolean success = false;
                try {
                    data = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader((DataInput)data, (String)"FixedDerefBytesDat", (int)0, (int)0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader((DataInput)index, (String)"FixedDerefBytesIdx", (int)0, (int)0);
                    final int fixedLength = data.readInt();
                    int valueCount = index.readInt();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(data, (long)fixedLength * (long)valueCount);
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader((DataInput)index);
                    CodecUtil.checkEOF((IndexInput)data);
                    CodecUtil.checkEOF((IndexInput)index);
                    long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesUsed);
                        this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"fixed deref", (long)bytesUsed));
                    }
                    success = true;
                    binaryDocValues = new BinaryDocValues(){

                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            long offset = (long)fixedLength * reader.get(docID);
                            bytesReader.fillSlice(term, offset, fixedLength);
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{data, index});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{data, index});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BinaryDocValues loadBytesVarDeref(FieldInfo field) throws IOException {
        BinaryDocValues binaryDocValues;
        block6: {
            IndexInput index;
            IndexInput data;
            block5: {
                String dataName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                String indexName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"idx");
                data = null;
                index = null;
                boolean success = false;
                try {
                    data = this.dir.openInput(dataName, this.state.context);
                    CodecUtil.checkHeader((DataInput)data, (String)"VarDerefBytesDat", (int)0, (int)0);
                    index = this.dir.openInput(indexName, this.state.context);
                    CodecUtil.checkHeader((DataInput)index, (String)"VarDerefBytesIdx", (int)0, (int)0);
                    long totalBytes = index.readLong();
                    PagedBytes bytes = new PagedBytes(16);
                    bytes.copy(data, totalBytes);
                    final PagedBytes.Reader bytesReader = bytes.freeze(true);
                    final PackedInts.Reader reader = PackedInts.getReader((DataInput)index);
                    CodecUtil.checkEOF((IndexInput)data);
                    CodecUtil.checkEOF((IndexInput)index);
                    long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
                    if (!this.merging) {
                        this.ramBytesUsed.addAndGet(bytesUsed);
                        this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"variable deref", (long)bytesUsed));
                    }
                    success = true;
                    binaryDocValues = new BinaryDocValues(){

                        public BytesRef get(int docID) {
                            BytesRef term = new BytesRef();
                            long startAddress = reader.get(docID);
                            BytesRef lengthBytes = new BytesRef();
                            bytesReader.fillSlice(lengthBytes, startAddress, 1);
                            byte code = lengthBytes.bytes[lengthBytes.offset];
                            if ((code & 0x80) == 0) {
                                bytesReader.fillSlice(term, startAddress + 1L, (int)code);
                            } else {
                                bytesReader.fillSlice(lengthBytes, startAddress + 1L, 1);
                                int length = (code & 0x7F) << 8 | lengthBytes.bytes[lengthBytes.offset] & 0xFF;
                                bytesReader.fillSlice(term, startAddress + 2L, length);
                            }
                            return term;
                        }
                    };
                    if (!success) break block5;
                }
                catch (Throwable throwable) {
                    if (success) {
                        IOUtils.close((Closeable[])new Closeable[]{data, index});
                    } else {
                        IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
                    }
                    throw throwable;
                }
                IOUtils.close((Closeable[])new Closeable[]{data, index});
                break block6;
            }
            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
        }
        return binaryDocValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized SortedDocValues getSorted(FieldInfo field) throws IOException {
        SortedDocValues instance;
        block10: {
            block11: {
                IndexInput index;
                IndexInput data;
                block9: {
                    instance = this.sortedInstances.get(field.name);
                    if (instance != null) break block10;
                    String dataName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"dat");
                    String indexName = IndexFileNames.segmentFileName((String)(this.state.segmentInfo.name + "_" + Integer.toString(field.number)), (String)segmentSuffix, (String)"idx");
                    data = null;
                    index = null;
                    boolean success = false;
                    try {
                        data = this.dir.openInput(dataName, this.state.context);
                        index = this.dir.openInput(indexName, this.state.context);
                        switch (Lucene40FieldInfosFormat.LegacyDocValuesType.valueOf(field.getAttribute(this.legacyKey))) {
                            case BYTES_FIXED_SORTED: {
                                instance = this.loadBytesFixedSorted(field, data, index);
                                break;
                            }
                            case BYTES_VAR_SORTED: {
                                instance = this.loadBytesVarSorted(field, data, index);
                                break;
                            }
                            default: {
                                throw new AssertionError();
                            }
                        }
                        CodecUtil.checkEOF((IndexInput)data);
                        CodecUtil.checkEOF((IndexInput)index);
                        success = true;
                        if (!success) break block9;
                    }
                    catch (Throwable throwable) {
                        if (success) {
                            IOUtils.close((Closeable[])new Closeable[]{data, index});
                        } else {
                            IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
                        }
                        throw throwable;
                    }
                    IOUtils.close((Closeable[])new Closeable[]{data, index});
                    break block11;
                }
                IOUtils.closeWhileHandlingException((Closeable[])new Closeable[]{data, index});
            }
            if (!this.merging) {
                this.sortedInstances.put(field.name, instance);
            }
        }
        return instance;
    }

    private SortedDocValues loadBytesFixedSorted(FieldInfo field, IndexInput data, IndexInput index) throws IOException {
        CodecUtil.checkHeader((DataInput)data, (String)"FixedSortedBytesDat", (int)0, (int)0);
        CodecUtil.checkHeader((DataInput)index, (String)"FixedSortedBytesIdx", (int)0, (int)0);
        final int fixedLength = data.readInt();
        final int valueCount = index.readInt();
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(data, (long)fixedLength * (long)valueCount);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        final PackedInts.Reader reader = PackedInts.getReader((DataInput)index);
        long bytesUsed = bytesReader.ramBytesUsed() + reader.ramBytesUsed();
        if (!this.merging) {
            this.ramBytesUsed.addAndGet(bytesUsed);
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"fixed sorted", (long)bytesUsed));
        }
        return this.correctBuggyOrds(new SortedDocValues(){

            public int getOrd(int docID) {
                return (int)reader.get(docID);
            }

            public BytesRef lookupOrd(int ord) {
                BytesRef term = new BytesRef();
                bytesReader.fillSlice(term, (long)fixedLength * (long)ord, fixedLength);
                return term;
            }

            public int getValueCount() {
                return valueCount;
            }
        });
    }

    private SortedDocValues loadBytesVarSorted(FieldInfo field, IndexInput data, IndexInput index) throws IOException {
        CodecUtil.checkHeader((DataInput)data, (String)"VarDerefBytesDat", (int)0, (int)0);
        CodecUtil.checkHeader((DataInput)index, (String)"VarDerefBytesIdx", (int)0, (int)0);
        long maxAddress = index.readLong();
        PagedBytes bytes = new PagedBytes(16);
        bytes.copy(data, maxAddress);
        final PagedBytes.Reader bytesReader = bytes.freeze(true);
        final PackedInts.Reader addressReader = PackedInts.getReader((DataInput)index);
        final PackedInts.Reader ordsReader = PackedInts.getReader((DataInput)index);
        final int valueCount = addressReader.size() - 1;
        long bytesUsed = bytesReader.ramBytesUsed() + addressReader.ramBytesUsed() + ordsReader.ramBytesUsed();
        if (!this.merging) {
            this.ramBytesUsed.addAndGet(bytesUsed);
            this.instanceInfo.put(field.name, Accountables.namedAccountable((String)"var sorted", (long)bytesUsed));
        }
        return this.correctBuggyOrds(new SortedDocValues(){

            public int getOrd(int docID) {
                return (int)ordsReader.get(docID);
            }

            public BytesRef lookupOrd(int ord) {
                BytesRef term = new BytesRef();
                long startAddress = addressReader.get(ord);
                long endAddress = addressReader.get(ord + 1);
                bytesReader.fillSlice(term, startAddress, (int)(endAddress - startAddress));
                return term;
            }

            public int getValueCount() {
                return valueCount;
            }
        });
    }

    private SortedDocValues correctBuggyOrds(final SortedDocValues in) {
        int maxDoc = this.state.segmentInfo.getDocCount();
        for (int i = 0; i < maxDoc; ++i) {
            if (in.getOrd(i) != 0) continue;
            return in;
        }
        return new SortedDocValues(){

            public int getOrd(int docID) {
                return in.getOrd(docID) - 1;
            }

            public BytesRef lookupOrd(int ord) {
                return in.lookupOrd(ord + 1);
            }

            public int getValueCount() {
                return in.getValueCount() - 1;
            }
        };
    }

    public SortedNumericDocValues getSortedNumeric(FieldInfo field) throws IOException {
        throw new IllegalStateException("Lucene 4.0 does not support SortedNumeric: how did you pull this off?");
    }

    public SortedSetDocValues getSortedSet(FieldInfo field) throws IOException {
        throw new IllegalStateException("Lucene 4.0 does not support SortedSet: how did you pull this off?");
    }

    public Bits getDocsWithField(FieldInfo field) throws IOException {
        return new Bits.MatchAllBits(this.state.segmentInfo.getDocCount());
    }

    public void close() throws IOException {
        this.dir.close();
    }

    public long ramBytesUsed() {
        return this.ramBytesUsed.get();
    }

    public synchronized Collection<Accountable> getChildResources() {
        return Accountables.namedAccountables((String)"field", this.instanceInfo);
    }

    public void checkIntegrity() throws IOException {
    }

    public synchronized DocValuesProducer getMergeInstance() throws IOException {
        return new Lucene40DocValuesReader(this);
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }
}

