/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.ant;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.Vector;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.SimpleAnalyzer;
import org.apache.lucene.analysis.StopAnalyzer;
import org.apache.lucene.analysis.WhitespaceAnalyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.ant.ConfigurableDocumentHandler;
import org.apache.lucene.ant.DocumentHandler;
import org.apache.lucene.ant.DocumentHandlerException;
import org.apache.lucene.ant.FileExtensionDocumentHandler;
import org.apache.lucene.document.DateTools;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.Fieldable;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.util.Version;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.DynamicConfigurator;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.EnumeratedAttribute;
import org.apache.tools.ant.types.FileSet;
import org.apache.tools.ant.types.Resource;
import org.apache.tools.ant.types.ResourceCollection;
import org.apache.tools.ant.types.resources.FileResource;

public class IndexTask
extends Task {
    protected Vector<ResourceCollection> rcs = new Vector();
    private boolean overwrite = false;
    private File indexDir;
    private String handlerClassName = FileExtensionDocumentHandler.class.getName();
    private DocumentHandler handler;
    private String analyzerClassName = StandardAnalyzer.class.getName();
    private Analyzer analyzer;
    private int mergeFactor = 20;
    private HandlerConfig handlerConfig;
    private boolean useCompoundIndex = true;

    public void setIndex(File indexDir) {
        this.indexDir = indexDir;
    }

    public void setMergeFactor(int mergeFactor) {
        this.mergeFactor = mergeFactor;
    }

    public void setOverwrite(boolean overwrite) {
        this.overwrite = overwrite;
    }

    public void setUseCompoundIndex(boolean useCompoundIndex) {
        this.useCompoundIndex = useCompoundIndex;
    }

    public void setDocumentHandler(String classname) {
        this.handlerClassName = classname;
    }

    public void setAnalyzer(AnalyzerType type) {
        this.analyzerClassName = type.getClassname();
    }

    public void setAnalyzerClassName(String classname) {
        this.analyzerClassName = classname;
    }

    public void addFileset(FileSet set) {
        this.add((ResourceCollection)set);
    }

    public void add(ResourceCollection res) {
        this.rcs.add(res);
    }

    public void addConfig(HandlerConfig config) throws BuildException {
        if (this.handlerConfig != null) {
            throw new BuildException("Only one config element allowed");
        }
        this.handlerConfig = config;
    }

    private static final Analyzer createAnalyzer(String className) throws Exception {
        Class<Analyzer> clazz = Class.forName(className).asSubclass(Analyzer.class);
        try {
            Constructor<Analyzer> cnstr = clazz.getConstructor(Version.class);
            return cnstr.newInstance(Version.LUCENE_CURRENT);
        }
        catch (NoSuchMethodException nsme) {
            return clazz.newInstance();
        }
    }

    public void execute() throws BuildException {
        try {
            this.handler = Class.forName(this.handlerClassName).asSubclass(DocumentHandler.class).newInstance();
            this.analyzer = IndexTask.createAnalyzer(this.analyzerClassName);
        }
        catch (Exception e) {
            throw new BuildException((Throwable)e);
        }
        this.log("Document handler = " + this.handler.getClass(), 3);
        this.log("Analyzer = " + this.analyzer.getClass(), 3);
        if (this.handler instanceof ConfigurableDocumentHandler) {
            ((ConfigurableDocumentHandler)this.handler).configure(this.handlerConfig.getProperties());
        }
        try {
            this.indexDocs();
        }
        catch (IOException e) {
            throw new BuildException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void indexDocs() throws IOException {
        Date start = new Date();
        boolean create = this.overwrite;
        if (this.indexDir.mkdirs() && !this.overwrite) {
            create = true;
        }
        FSDirectory dir = FSDirectory.open((File)this.indexDir);
        try {
            IndexSearcher searcher = null;
            boolean checkLastModified = false;
            if (!create) {
                try {
                    searcher = new IndexSearcher((Directory)dir, true);
                    checkLastModified = true;
                }
                catch (IOException ioe) {
                    this.log("IOException: " + ioe.getMessage());
                }
            }
            this.log("checkLastModified = " + checkLastModified, 3);
            IndexWriter writer = new IndexWriter((Directory)dir, this.analyzer, create, IndexWriter.MaxFieldLength.LIMITED);
            writer.setUseCompoundFile(this.useCompoundIndex);
            int totalFiles = 0;
            int totalIndexed = 0;
            int totalIgnored = 0;
            try {
                writer.setMergeFactor(this.mergeFactor);
                for (int i = 0; i < this.rcs.size(); ++i) {
                    ResourceCollection rc = this.rcs.elementAt(i);
                    if (!rc.isFilesystemOnly()) continue;
                    for (Resource r : rc) {
                        if (!r.isExists() || !(r instanceof FileResource)) continue;
                        ++totalFiles;
                        File file = ((FileResource)r).getFile();
                        if (!file.exists() || !file.canRead()) {
                            throw new BuildException("File \"" + file.getAbsolutePath() + "\" does not exist or is not readable.");
                        }
                        boolean indexIt = true;
                        if (checkLastModified) {
                            Document doc;
                            String indexModified;
                            Term pathTerm = new Term("path", file.getPath());
                            TermQuery query = new TermQuery(pathTerm);
                            ScoreDoc[] hits = searcher.search((Query)query, null, (int)1).scoreDocs;
                            if (hits.length > 0 && (indexModified = (doc = searcher.doc(hits[0].doc)).get("modified").trim()) != null) {
                                long lastModified = 0L;
                                try {
                                    lastModified = DateTools.stringToTime((String)indexModified);
                                }
                                catch (ParseException e) {
                                    // empty catch block
                                }
                                if (lastModified == file.lastModified()) {
                                    indexIt = false;
                                }
                            }
                        }
                        if (!indexIt) continue;
                        try {
                            this.log("Indexing " + file.getPath(), 3);
                            Document doc = this.handler.getDocument(file);
                            if (doc == null) {
                                ++totalIgnored;
                                continue;
                            }
                            doc.add((Fieldable)new Field("path", file.getPath(), Field.Store.YES, Field.Index.NOT_ANALYZED));
                            doc.add((Fieldable)new Field("modified", DateTools.timeToString((long)file.lastModified(), (DateTools.Resolution)DateTools.Resolution.MILLISECOND), Field.Store.YES, Field.Index.NOT_ANALYZED));
                            writer.addDocument(doc);
                            ++totalIndexed;
                        }
                        catch (DocumentHandlerException e) {
                            throw new BuildException((Throwable)e);
                        }
                    }
                }
                writer.optimize();
            }
            finally {
                writer.close();
                if (searcher != null) {
                    searcher.close();
                }
            }
            Date end = new Date();
            this.log(totalIndexed + " out of " + totalFiles + " indexed (" + totalIgnored + " ignored) in " + (end.getTime() - start.getTime()) + " milliseconds");
        }
        finally {
            dir.close();
        }
    }

    public static class AnalyzerType
    extends EnumeratedAttribute {
        private static Map<String, String> analyzerLookup = new HashMap<String, String>();

        public String[] getValues() {
            Set<String> keys = analyzerLookup.keySet();
            return keys.toArray(new String[0]);
        }

        public String getClassname() {
            return analyzerLookup.get(this.getValue());
        }

        static {
            analyzerLookup.put("simple", SimpleAnalyzer.class.getName());
            analyzerLookup.put("standard", StandardAnalyzer.class.getName());
            analyzerLookup.put("stop", StopAnalyzer.class.getName());
            analyzerLookup.put("whitespace", WhitespaceAnalyzer.class.getName());
        }
    }

    public static class HandlerConfig
    implements DynamicConfigurator {
        Properties props = new Properties();

        public void setDynamicAttribute(String attributeName, String value) throws BuildException {
            this.props.setProperty(attributeName, value);
        }

        public Object createDynamicElement(String elementName) throws BuildException {
            throw new BuildException("Sub elements not supported");
        }

        public Properties getProperties() {
            return this.props;
        }
    }
}

