/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.IOException;
import java.io.Reader;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.analysis.Tokenizer;

public class EdgeNGramTokenizer
extends Tokenizer {
    private int gramSize;
    private Side side;
    private int inLen;
    private String inStr;
    private boolean started = false;

    public EdgeNGramTokenizer(Reader input, Side side, int gramSize) {
        super(input);
        if (gramSize < 1) {
            throw new IllegalArgumentException("gramSize must be greater than zero");
        }
        this.gramSize = gramSize;
        this.side = side;
    }

    public EdgeNGramTokenizer(Reader input, String side, int gramSize) {
    }

    public final Token next() throws IOException {
        if (this.started) {
            return null;
        }
        if (!this.started) {
            this.started = true;
            char[] chars = new char[1024];
            this.input.read(chars);
            this.inStr = new String(chars).trim();
            this.inLen = this.inStr.length();
        }
        if (this.gramSize > this.inLen) {
            return null;
        }
        if (this.side == Side.FRONT) {
            return new Token(this.inStr.substring(0, this.gramSize), 0, this.gramSize);
        }
        return new Token(this.inStr.substring(this.inLen - this.gramSize), this.inLen - this.gramSize, this.inLen);
    }

    static Side side(String label) {
        if (label == null || label.trim().length() == 0) {
            throw new IllegalArgumentException("Label must be either 'front' or 'back'");
        }
        if (label.equals("front")) {
            return Side.FRONT;
        }
        return Side.BACK;
    }

    public static class Side {
        public static Side FRONT = new Side("front");
        public static Side BACK = new Side("back");

        private Side(String label) {
        }
    }
}

