/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.uima;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.tokenattributes.CharTermAttribute;
import org.apache.lucene.analysis.tokenattributes.OffsetAttribute;
import org.apache.lucene.analysis.uima.BaseUIMATokenizer;
import org.apache.lucene.util.AttributeSource;
import org.apache.uima.analysis_engine.AnalysisEngineProcessException;
import org.apache.uima.cas.Type;
import org.apache.uima.cas.text.AnnotationFS;
import org.apache.uima.resource.ResourceInitializationException;

public final class UIMAAnnotationsTokenizer
extends BaseUIMATokenizer {
    private final CharTermAttribute termAttr;
    private final OffsetAttribute offsetAttr;
    private final String tokenTypeString;
    private int finalOffset = 0;

    public UIMAAnnotationsTokenizer(String descriptorPath, String tokenType, Map<String, Object> configurationParameters, Reader input) {
        this(descriptorPath, tokenType, configurationParameters, AttributeSource.AttributeFactory.DEFAULT_ATTRIBUTE_FACTORY, input);
    }

    public UIMAAnnotationsTokenizer(String descriptorPath, String tokenType, Map<String, Object> configurationParameters, AttributeSource.AttributeFactory factory, Reader input) {
        super(factory, input, descriptorPath, configurationParameters);
        this.tokenTypeString = tokenType;
        this.termAttr = (CharTermAttribute)this.addAttribute(CharTermAttribute.class);
        this.offsetAttr = (OffsetAttribute)this.addAttribute(OffsetAttribute.class);
    }

    @Override
    protected void initializeIterator() throws IOException {
        try {
            this.analyzeInput();
        }
        catch (AnalysisEngineProcessException e) {
            throw new IOException(e);
        }
        catch (ResourceInitializationException e) {
            throw new IOException(e);
        }
        this.finalOffset = this.correctOffset(this.cas.getDocumentText().length());
        Type tokenType = this.cas.getTypeSystem().getType(this.tokenTypeString);
        this.iterator = this.cas.getAnnotationIndex(tokenType).iterator();
    }

    public boolean incrementToken() throws IOException {
        if (this.iterator == null) {
            this.initializeIterator();
        }
        if (this.iterator.hasNext()) {
            this.clearAttributes();
            AnnotationFS next = (AnnotationFS)this.iterator.next();
            this.termAttr.append(next.getCoveredText());
            this.offsetAttr.setOffset(this.correctOffset(next.getBegin()), this.correctOffset(next.getEnd()));
            return true;
        }
        return false;
    }

    public void end() throws IOException {
        super.end();
        this.offsetAttr.setOffset(this.finalOffset, this.finalOffset);
    }
}

