/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.ngram.NGramTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeSource;

public class NGramTokenizerFactory
extends TokenizerFactory {
    private final int maxGramSize;
    private final int minGramSize;

    public NGramTokenizerFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 2);
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public NGramTokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
        return new NGramTokenizer(factory, input, this.minGramSize, this.maxGramSize);
    }
}

