/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.analysis.ngram;

import java.io.Reader;
import java.util.Map;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenFilter;
import org.apache.lucene.analysis.ngram.EdgeNGramTokenizer;
import org.apache.lucene.analysis.util.TokenizerFactory;
import org.apache.lucene.util.AttributeSource;

public class EdgeNGramTokenizerFactory
extends TokenizerFactory {
    private final int maxGramSize;
    private final int minGramSize;
    private final String side;

    public EdgeNGramTokenizerFactory(Map<String, String> args) {
        super(args);
        this.minGramSize = this.getInt(args, "minGramSize", 1);
        this.maxGramSize = this.getInt(args, "maxGramSize", 1);
        this.side = this.get(args, "side", EdgeNGramTokenFilter.Side.FRONT.getLabel());
        if (!args.isEmpty()) {
            throw new IllegalArgumentException("Unknown parameters: " + args);
        }
    }

    @Override
    public EdgeNGramTokenizer create(AttributeSource.AttributeFactory factory, Reader input) {
        return new EdgeNGramTokenizer(factory, input, this.side, this.minGramSize, this.maxGramSize);
    }
}

