/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.message.ParameterizedMessage;
import org.apache.logging.log4j.spi.DefaultThreadContextMap;
import org.apache.logging.log4j.spi.LoggerContextFactory;
import org.apache.logging.log4j.spi.Provider;
import org.apache.logging.log4j.spi.ThreadContextMap;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.PropertiesUtil;
import org.apache.logging.log4j.util.ProviderUtil;

public final class ThreadContext {
    public static final Map<String, String> EMPTY_MAP = new ImmutableMap();
    public static final ContextStack EMPTY_STACK = new ImmutableStack();
    private static final String DISABLE_MAP = "disableThreadContextMap";
    private static final String DISABLE_STACK = "disableThreadContextStack";
    private static final String DISABLE_ALL = "disableThreadContext";
    private static final String THREAD_CONTEXT_KEY = "log4j2.threadContextMap";
    private static boolean all;
    private static boolean useMap;
    private static boolean useStack;
    private static ThreadContextMap contextMap;
    private static final Logger LOGGER;
    private static ThreadLocal<ContextStack> localStack;

    private ThreadContext() {
    }

    public static void put(String key, String value) {
        contextMap.put(key, value);
    }

    public static String get(String key) {
        return contextMap.get(key);
    }

    public static void remove(String key) {
        contextMap.remove(key);
    }

    public static void clear() {
        contextMap.clear();
    }

    public static boolean containsKey(String key) {
        return contextMap.containsKey(key);
    }

    public static Map<String, String> getContext() {
        return contextMap.getContext();
    }

    public static Map<String, String> getImmutableContext() {
        Map<String, String> map = contextMap.get();
        return map == null ? new ImmutableMap() : new ImmutableMap(map);
    }

    public static boolean isEmpty() {
        return contextMap.isEmpty();
    }

    public static void clearStack() {
        localStack.remove();
    }

    public static ContextStack cloneStack() {
        ContextStack stack = localStack.get();
        return stack == null ? new ThreadContextStack() : new ThreadContextStack((Collection<String>)stack.asList());
    }

    public static ContextStack getImmutableStack() {
        ContextStack stack = localStack.get();
        return stack == null ? EMPTY_STACK : new ImmutableStack((Collection<String>)stack.asList());
    }

    public static void setStack(Collection<String> stack) {
        if (stack.size() == 0 || !useStack) {
            return;
        }
        localStack.set(new ThreadContextStack(stack));
    }

    public static int getDepth() {
        ContextStack stack = localStack.get();
        return stack == null ? 0 : stack.getDepth();
    }

    public static String pop() {
        ContextStack s = localStack.get();
        if (s == null || s.getDepth() == 0) {
            return "";
        }
        return s.pop();
    }

    public static String peek() {
        ContextStack s = localStack.get();
        if (s == null || s.getDepth() == 0) {
            return "";
        }
        return s.peek();
    }

    public static void push(String message) {
        if (!useStack) {
            return;
        }
        ContextStack stack = localStack.get();
        if (stack == null) {
            stack = new ThreadContextStack();
            localStack.set(stack);
        }
        stack.push(message);
    }

    public static void push(String message, Object ... args) {
        if (!useStack) {
            return;
        }
        ContextStack stack = localStack.get();
        if (stack == null) {
            stack = new ThreadContextStack();
            localStack.set(stack);
        }
        stack.push(ParameterizedMessage.format(message, args));
    }

    public static void removeStack() {
        localStack.remove();
    }

    public static void trim(int depth) {
        ContextStack stack = localStack.get();
        if (stack != null) {
            stack.trim(depth);
        }
    }

    static {
        LOGGER = StatusLogger.getLogger();
        PropertiesUtil managerProps = PropertiesUtil.getProperties();
        all = managerProps.getBooleanProperty(DISABLE_ALL);
        useMap = !managerProps.getBooleanProperty(DISABLE_MAP) && !all;
        useStack = !managerProps.getBooleanProperty(DISABLE_STACK) && !all;
        String threadContextMapName = managerProps.getStringProperty(THREAD_CONTEXT_KEY);
        ClassLoader cl = ProviderUtil.findClassLoader();
        if (threadContextMapName != null) {
            try {
                Class<?> clazz = cl.loadClass(threadContextMapName);
                if (ThreadContextMap.class.isAssignableFrom(clazz)) {
                    contextMap = (ThreadContextMap)clazz.newInstance();
                }
            }
            catch (ClassNotFoundException cnfe) {
                LOGGER.error("Unable to locate configured LoggerContextFactory {}", threadContextMapName);
            }
            catch (Exception ex) {
                LOGGER.error("Unable to create configured LoggerContextFactory {}", threadContextMapName, ex);
            }
        }
        if (contextMap == null && ProviderUtil.hasProviders()) {
            LoggerContextFactory factory = LogManager.getFactory();
            Iterator<Provider> providers = ProviderUtil.getProviders();
            while (providers.hasNext()) {
                Provider provider = providers.next();
                threadContextMapName = provider.getThreadContextMap();
                String factoryClassName = provider.getClassName();
                if (threadContextMapName == null || !factory.getClass().getName().equals(factoryClassName)) continue;
                try {
                    Class<?> clazz = cl.loadClass(threadContextMapName);
                    if (!ThreadContextMap.class.isAssignableFrom(clazz)) continue;
                    contextMap = (ThreadContextMap)clazz.newInstance();
                    break;
                }
                catch (ClassNotFoundException cnfe) {
                    LOGGER.error("Unable to locate configured LoggerContextFactory {}", threadContextMapName);
                    contextMap = new DefaultThreadContextMap(useMap);
                }
                catch (Exception ex) {
                    LOGGER.error("Unable to create configured LoggerContextFactory {}", threadContextMapName, ex);
                    contextMap = new DefaultThreadContextMap(useMap);
                }
            }
            if (contextMap == null) {
                contextMap = new DefaultThreadContextMap(useMap);
            }
        } else {
            contextMap = new DefaultThreadContextMap(useMap);
        }
        localStack = new ThreadLocal();
    }

    public static class ImmutableMap
    extends HashMap<String, String> {
        private static final long serialVersionUID = 5050503L;

        public ImmutableMap() {
        }

        public ImmutableMap(Map<String, String> map) {
            super(map);
        }

        @Override
        public String put(String s, String s1) {
            throw new UnsupportedOperationException("Map cannot be modified");
        }

        @Override
        public void putAll(Map<? extends String, ? extends String> map) {
            throw new UnsupportedOperationException("Map cannot be modified");
        }

        @Override
        public String remove(Object o) {
            throw new UnsupportedOperationException("Map cannot be modified");
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException("Map cannot be modified");
        }
    }

    public static class ImmutableStack
    extends ThreadContextStack {
        private static final long serialVersionUID = 5050502L;

        public ImmutableStack() {
        }

        public ImmutableStack(Collection<String> collection) {
            super(collection);
        }

        public ImmutableStack(ThreadContextStack stack) {
            super(stack);
        }

        @Override
        public void push(String message) {
            throw new UnsupportedOperationException("Stack cannot be modified");
        }

        @Override
        public void trim(int depth) {
            throw new UnsupportedOperationException("Stack cannot be modified");
        }
    }

    private static class ThreadContextStack
    extends ArrayList<String>
    implements ContextStack {
        private static final long serialVersionUID = 5050501L;

        public ThreadContextStack() {
        }

        public ThreadContextStack(Collection<String> collection) {
            super(collection);
        }

        @Override
        public String pop() {
            int index = this.size() - 1;
            if (index >= 0) {
                String result = (String)this.get(index);
                this.remove(index);
                return result;
            }
            throw new NoSuchElementException("The ThreadContext stack is empty");
        }

        @Override
        public String peek() {
            int index = this.size() - 1;
            if (index >= 0) {
                return (String)this.get(index);
            }
            return null;
        }

        @Override
        public void push(String message) {
            this.add(message);
        }

        @Override
        public int getDepth() {
            return this.size();
        }

        @Override
        public List<String> asList() {
            return this;
        }

        @Override
        public void trim(int depth) {
            if (depth < 0) {
                throw new IllegalArgumentException("Maximum stack depth cannot be negative");
            }
            while (this.size() > depth) {
                this.remove(this.size() - 1);
            }
        }

        @Override
        public ContextStack copy() {
            return new ThreadContextStack(this);
        }
    }

    public static interface ContextStack
    extends Serializable {
        public void clear();

        public String pop();

        public String peek();

        public void push(String var1);

        public int getDepth();

        public List<String> asList();

        public void trim(int var1);

        public ContextStack copy();
    }
}

