/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.metadata.query.service;

import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.MongoSecurityException;
import com.mongodb.MongoSocketException;
import com.mongodb.ServerAddress;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.MongoIterable;
import com.mongodb.client.model.Sorts;
import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.linkis.common.conf.CommonVars;
import org.apache.linkis.metadata.query.common.domain.MetaColumnInfo;
import org.bson.Document;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MongoDbConnection
implements Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbConnection.class);
    private static final CommonVars<Integer> CONNECTIONS_PER_HOST = CommonVars.apply((String)"wds.linkis.server.mdm.service.mongo.driver", (Object)5);
    private static final CommonVars<Integer> CONNECT_TIMEOUT = CommonVars.apply((String)"wds.linkis.server.mdm.service.mongo.connect.timeout", (Object)3000);
    private static final CommonVars<Integer> SOCKET_TIMEOUT = CommonVars.apply((String)"wds.linkis.server.mdm.service.mongo.socket.timeout", (Object)6000);
    private static final int DOC_FETCH_LIMIT = 100;
    private static final String DEFAULT_PRIMARY_KEY = "_id";
    private static final MongoClientOptions CLIENT_SERVICE_OPTIONS = MongoClientOptions.builder().connectionsPerHost(5).socketTimeout(6000).connectTimeout(3000).serverSelectionTimeout(50).build();
    private MongoClient conn;
    private ConnectMessage connectMessage;

    public MongoDbConnection(String host, Integer port, String username, String password, String database, Map<String, Object> extraParams) throws ClassNotFoundException, Exception {
        this.connectMessage = new ConnectMessage(host, port, username, password, database, extraParams);
        this.conn = this.getDBConnection(this.connectMessage, database);
    }

    public List<String> getAllDatabases() throws Exception {
        LOG.info("start to get database");
        ArrayList<String> databases = new ArrayList<String>();
        MongoIterable databaseNamesIter = this.conn.listDatabaseNames();
        for (String databaseName : databaseNamesIter) {
            databases.add(databaseName);
        }
        return databases;
    }

    public List<String> getAllTables(String database) throws Exception {
        ArrayList<String> collectionNames = new ArrayList<String>();
        MongoDatabase mdb = this.conn.getDatabase(database);
        MongoIterable collections = mdb.listCollectionNames();
        for (String cname : collections) {
            collectionNames.add(cname);
        }
        return collectionNames;
    }

    public List<MetaColumnInfo> getColumns(String database, String collection) throws Exception, ClassNotFoundException {
        ArrayList<MetaColumnInfo> metaColumnInfo = new ArrayList<MetaColumnInfo>();
        MongoDatabase mdb = this.conn.getDatabase(database);
        MongoCollection collection1 = mdb.getCollection(collection);
        MongoCursor dbCursor = collection1.find().sort(Sorts.descending((String[])new String[]{DEFAULT_PRIMARY_KEY})).batchSize(100).limit(100).iterator();
        int maxFieldSize = Integer.MIN_VALUE;
        Document maxDocument = null;
        while (dbCursor.hasNext()) {
            Document document = (Document)dbCursor.next();
            if (document.keySet().size() <= maxFieldSize) continue;
            maxDocument = document;
            maxFieldSize = document.keySet().size();
        }
        if (Objects.nonNull(maxDocument)) {
            AtomicInteger index = new AtomicInteger(0);
            maxDocument.forEach((colName, colValue) -> {
                MetaColumnInfo info = new MetaColumnInfo();
                info.setIndex(index.getAndIncrement());
                info.setName(colName);
                info.setType(Objects.nonNull(colValue) ? colValue.getClass().getSimpleName() : "Null");
                if (info.getName().equals(DEFAULT_PRIMARY_KEY)) {
                    info.setPrimaryKey(true);
                }
                metaColumnInfo.add(info);
            });
        }
        return metaColumnInfo;
    }

    private List<String> getPrimaryKeys(MongoClient connection, String database, String collection) throws Exception {
        ArrayList<String> primaryKeys = new ArrayList<String>();
        primaryKeys.add(DEFAULT_PRIMARY_KEY);
        return primaryKeys;
    }

    private void closeResource(MongoClient connection) {
        if (null != connection) {
            connection.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closeResource(this.conn);
    }

    private MongoClient getDBConnection(ConnectMessage connectMessage, String database) throws Exception {
        LOG.info("mongo information is database:{}, username:{}", (Object)database, (Object)connectMessage.username);
        MongoClient client = null;
        try {
            MongoCredential credential = MongoCredential.createCredential((String)connectMessage.username, (String)database, (char[])connectMessage.password.toCharArray());
            ServerAddress address = new ServerAddress(connectMessage.host, connectMessage.port.intValue());
            client = new MongoClient(address, credential, CLIENT_SERVICE_OPTIONS);
            MongoDatabase mdb = client.getDatabase(database);
            MongoIterable collectionname = mdb.listCollectionNames();
            collectionname.first();
            return client;
        }
        catch (MongoSocketException e) {
            throw new RuntimeException("Fail in building socket connection to Mongo server: [ host: " + connectMessage.host + ", port: " + connectMessage.port + "]", e);
        }
        catch (MongoSecurityException e) {
            throw new RuntimeException("Fail to authenticate to Mongo server: [ host: " + connectMessage.host + ", port: " + connectMessage.port + ", username: " + connectMessage.username + "]", e);
        }
        catch (IllegalArgumentException e) {
            throw new IllegalArgumentException(e);
        }
        catch (Exception e) {
            LOG.error("exchange.mongodb.obtain.data_source.info.failed" + e.getMessage());
            throw new Exception();
        }
    }

    private static class ConnectMessage {
        private String host;
        private Integer port;
        private String username;
        private String password;
        private String database;
        private Map<String, Object> extraParams;

        public ConnectMessage(String host, Integer port, String username, String password, String database, Map<String, Object> extraParams) {
            this.host = host;
            this.port = port;
            this.username = username;
            this.password = password;
            this.database = database;
            if (extraParams != null) {
                this.extraParams = extraParams;
            }
            this.extraParams = extraParams;
            this.extraParams.put("connectTimeout", CONNECT_TIMEOUT.getValue());
            this.extraParams.put("socketTimeout", SOCKET_TIMEOUT.getValue());
        }
    }
}

