/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ujes.jdbc.utils;

import java.util.concurrent.atomic.AtomicInteger;
import org.apache.linkis.common.utils.Utils;

public class JDBCUtils {
    private static final char SEARCH_STRING_ESCAPE = '\\';
    public static final AtomicInteger idCreator = new AtomicInteger();

    public static String convertPattern(String pattern) {
        if (pattern == null) {
            return ".*";
        }
        StringBuilder result = new StringBuilder(pattern.length());
        boolean escaped = false;
        int len = pattern.length();
        for (int i = 0; i < len; ++i) {
            char c = pattern.charAt(i);
            if (escaped) {
                if (c != '\\') {
                    escaped = false;
                }
                result.append(c);
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '%') {
                result.append(".*");
                continue;
            }
            result.append(Character.toLowerCase(c));
        }
        return result.toString();
    }

    public static String getUniqId() {
        return Utils.getLocalHostname() + "_" + idCreator.getAndIncrement();
    }
}

