/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.trino.interceptor;

import java.io.IOException;
import javax.security.auth.callback.PasswordCallback;
import okhttp3.Credentials;
import okhttp3.Interceptor;
import okhttp3.Response;

public class PasswordInterceptor
implements Interceptor {
    private final String user;
    private final PasswordCallback callback;
    private volatile String credentials = null;
    private volatile long expiredTimestamp = 0L;

    public PasswordInterceptor(String user, PasswordCallback callback) {
        this.user = user;
        this.callback = callback;
    }

    public Response intercept(Interceptor.Chain chain) throws IOException {
        return chain.proceed(chain.request().newBuilder().header("Authorization", this.credentials()).build());
    }

    private synchronized String credentials() {
        long timeMillis = System.currentTimeMillis();
        if (this.credentials == null || timeMillis > this.expiredTimestamp) {
            this.expiredTimestamp = timeMillis + 600000L;
            this.credentials = Credentials.basic((String)this.user, (String)new String(this.callback.getPassword()));
        }
        return this.credentials;
    }
}

