/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.spark.executor;

import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.linkis.common.exception.FatalException;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.engineconn.core.executor.ExecutorManager$;
import org.apache.linkis.engineplugin.spark.common.Kind;
import org.apache.linkis.engineplugin.spark.common.SparkDataCalc;
import org.apache.linkis.engineplugin.spark.datacalc.DataCalcExecution$;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSink;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcSource;
import org.apache.linkis.engineplugin.spark.datacalc.api.DataCalcTransform;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcArrayData;
import org.apache.linkis.engineplugin.spark.datacalc.model.DataCalcGroupData;
import org.apache.linkis.engineplugin.spark.entity.SparkEngineSession;
import org.apache.linkis.engineplugin.spark.executor.SparkEngineConnExecutor;
import org.apache.linkis.engineplugin.spark.utils.EngineUtils$;
import org.apache.linkis.governance.common.paser.CodeParser;
import org.apache.linkis.governance.common.paser.EmptyCodeParser;
import org.apache.linkis.scheduler.executer.ErrorExecuteResponse;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.scheduler.executer.SuccessExecuteResponse;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Tuple3;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001i4A!\u0003\u0006\u0001/!AA\u0004\u0001B\u0001B\u0003%Q\u0004\u0003\u0005$\u0001\t\u0005\t\u0015!\u0003%\u0011\u0015Q\u0003\u0001\"\u0001,\u0011\u0015y\u0003\u0001\"\u00111\u0011\u0015!\u0004\u0001\"\u00116\u0011\u0015Y\u0006\u0001\"\u0001]\u0011\u0015\u0001\b\u0001\"\u0015r\u0011\u0015\u0011\b\u0001\"\u0015t\u0005U\u0019\u0006/\u0019:l\t\u0006$\u0018mQ1mG\u0016CXmY;u_JT!a\u0003\u0007\u0002\u0011\u0015DXmY;u_JT!!\u0004\b\u0002\u000bM\u0004\u0018M]6\u000b\u0005=\u0001\u0012\u0001D3oO&tW\r\u001d7vO&t'BA\t\u0013\u0003\u0019a\u0017N\\6jg*\u00111\u0003F\u0001\u0007CB\f7\r[3\u000b\u0003U\t1a\u001c:h\u0007\u0001\u0019\"\u0001\u0001\r\u0011\u0005eQR\"\u0001\u0006\n\u0005mQ!aF*qCJ\\WI\\4j]\u0016\u001cuN\u001c8Fq\u0016\u001cW\u000f^8s\u0003I\u0019\b/\u0019:l\u000b:<\u0017N\\3TKN\u001c\u0018n\u001c8\u0011\u0005y\tS\"A\u0010\u000b\u0005\u0001b\u0011AB3oi&$\u00180\u0003\u0002#?\t\u00112\u000b]1sW\u0016sw-\u001b8f'\u0016\u001c8/[8o\u0003\tIG\r\u0005\u0002&Q5\taEC\u0001(\u0003\u0015\u00198-\u00197b\u0013\tIcE\u0001\u0003M_:<\u0017A\u0002\u001fj]&$h\bF\u0002-[9\u0002\"!\u0007\u0001\t\u000bq\u0019\u0001\u0019A\u000f\t\u000b\r\u001a\u0001\u0019\u0001\u0013\u0002\t%t\u0017\u000e\u001e\u000b\u0002cA\u0011QEM\u0005\u0003g\u0019\u0012A!\u00168ji\u00069!/\u001e8D_\u0012,G#\u0002\u001c?\u007f1K\u0006CA\u001c=\u001b\u0005A$BA\u001d;\u0003!)\u00070Z2vi\u0016\u0014(BA\u001e\u0011\u0003%\u00198\r[3ek2,'/\u0003\u0002>q\tyQ\t_3dkR,'+Z:q_:\u001cX\rC\u0003\f\u000b\u0001\u0007\u0001\u0004C\u0003A\u000b\u0001\u0007\u0011)\u0001\u0003d_\u0012,\u0007C\u0001\"J\u001d\t\u0019u\t\u0005\u0002EM5\tQI\u0003\u0002G-\u00051AH]8pizJ!\u0001\u0013\u0014\u0002\rA\u0013X\rZ3g\u0013\tQ5J\u0001\u0004TiJLgn\u001a\u0006\u0003\u0011\u001aBQ!T\u0003A\u00029\u000bqaY8oi\u0016DH\u000f\u0005\u0002P/6\t\u0001K\u0003\u0002R%\u00069Q\r_3dkR,'BA\u0006T\u0015\t!V+A\u0006d_6\u0004X\u000f^1uS>t'B\u0001,\u0011\u0003))gnZ5oK\u000e|gN\\\u0005\u00031B\u0013a#\u00128hS:,W\t_3dkRLwN\\\"p]R,\u0007\u0010\u001e\u0005\u00065\u0016\u0001\r!Q\u0001\tU>\u0014wI]8va\u0006\u0001r-\u001a;FeJ|'OU3ta>t7/\u001a\u000b\u0004;\u0002\\\u0007CA\u001c_\u0013\ty\u0006H\u0001\u000bFeJ|'/\u0012=fGV$XMU3ta>t7/\u001a\u0005\u0006C\u001a\u0001\rAY\u0001\ni\"\u0014xn^1cY\u0016\u0004\"a\u00195\u000f\u0005\u00114gB\u0001#f\u0013\u00059\u0013BA4'\u0003\u001d\u0001\u0018mY6bO\u0016L!!\u001b6\u0003\u0013QC'o\\<bE2,'BA4'\u0011\u0015ag\u00011\u0001n\u00031qW-\u001a3U_N#x\u000e]#D!\t)c.\u0003\u0002pM\t9!i\\8mK\u0006t\u0017aE4fi\u0016CXmY;u_JLE\r\u0015:f\r&DX#A!\u0002\u000f\u001d,GoS5oIV\tA\u000f\u0005\u0002vq6\taO\u0003\u0002x\u0019\u000511m\\7n_:L!!\u001f<\u0003\t-Kg\u000e\u001a")
public class SparkDataCalcExecutor
extends SparkEngineConnExecutor {
    private final SparkEngineSession sparkEngineSession;

    @Override
    public void init() {
        this.setCodeParser((CodeParser)new EmptyCodeParser());
        super.init();
        this.logger().info("spark data-calc executor start");
    }

    @Override
    public ExecuteResponse runCode(SparkEngineConnExecutor executor, String code, EngineExecutionContext context, String jobGroup) {
        this.logger().info(new StringBuilder(28).append("DataCalcExecutor run query: ").append(code).toString());
        context.appendStdout(new StringBuilder(4).append(EngineUtils$.MODULE$.getName()).append(" >> ").append(code).toString());
        return (ExecuteResponse)Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String execType = context.getProperties().getOrDefault("exec-type", "array").toString();
            if ("group".equals(execType)) {
                Tuple3<DataCalcSource<SR>[], DataCalcTransform<TR>[], DataCalcSink<SK>[]> tuple3 = DataCalcExecution$.MODULE$.getPlugins(DataCalcGroupData.getData(code));
                if (tuple3 == null) {
                    throw new MatchError(tuple3);
                }
                DataCalcSource[] sources = (DataCalcSource[])tuple3._1();
                DataCalcTransform[] transformations = (DataCalcTransform[])tuple3._2();
                DataCalcSink[] sinks = (DataCalcSink[])tuple3._3();
                Tuple3 tuple32 = new Tuple3((Object)sources, (Object)transformations, (Object)sinks);
                DataCalcSource[] sources2 = (DataCalcSource[])tuple32._1();
                DataCalcTransform[] transformations2 = (DataCalcTransform[])tuple32._2();
                DataCalcSink[] sinks2 = (DataCalcSink[])tuple32._3();
                DataCalcExecution$.MODULE$.execute($this.sparkEngineSession.sparkSession(), sources2, transformations2, sinks2);
            } else {
                Object[] plugins = DataCalcExecution$.MODULE$.getPlugins(DataCalcArrayData.getData(code));
                DataCalcExecution$.MODULE$.execute($this.sparkEngineSession.sparkSession(), plugins);
            }
            return new SuccessExecuteResponse();
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof InvocationTargetException) {
                InvocationTargetException invocationTargetException = (InvocationTargetException)throwable;
                this.logger().error("execute sparkDataCalc has InvocationTargetException!", (Throwable)invocationTargetException);
                Throwable cause = ExceptionUtils.getCause((Throwable)invocationTargetException);
                if (cause == null) {
                    cause = invocationTargetException;
                }
                return new ErrorExecuteResponse(ExceptionUtils.getRootCauseMessage((Throwable)invocationTargetException), cause);
            }
            if (throwable instanceof FatalException) {
                FatalException fatalException = (FatalException)throwable;
                return this.getErrorResponse((Throwable)fatalException, true);
            }
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                return this.getErrorResponse(exception, false);
            }
            if (throwable instanceof VirtualMachineError) {
                VirtualMachineError virtualMachineError = (VirtualMachineError)throwable;
                return this.getErrorResponse(virtualMachineError, true);
            }
            if (throwable instanceof Error) {
                Error error = (Error)throwable;
                return this.getErrorResponse(error, false);
            }
            throw new MatchError((Object)throwable);
        });
    }

    public ErrorExecuteResponse getErrorResponse(Throwable throwable, boolean needToStopEC) {
        Object object;
        if (needToStopEC) {
            this.logger().error(new StringBuilder(52).append("execute sparkSQL has ").append(throwable.getClass().getName()).append(" now to set status to shutdown!").toString(), throwable);
            object = BoxesRunTime.boxToBoolean((boolean)ExecutorManager$.MODULE$.getInstance().getReportExecutor().tryShutdown());
        } else {
            this.logger().error(new StringBuilder(22).append("execute sparkSQL has ").append(throwable.getClass().getName()).append("!").toString(), throwable);
            object = BoxedUnit.UNIT;
        }
        return new ErrorExecuteResponse(ExceptionUtils.getRootCauseMessage((Throwable)throwable), throwable);
    }

    @Override
    public String getExecutorIdPreFix() {
        return "SparkDataCalcExecutor_";
    }

    @Override
    public Kind getKind() {
        return new SparkDataCalc();
    }

    public SparkDataCalcExecutor(SparkEngineSession sparkEngineSession, long id) {
        this.sparkEngineSession = sparkEngineSession;
        super(sparkEngineSession.sparkContext(), id);
    }
}

