/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.core.flink;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.linkis.engineconnplugin.seatunnel.util.SeatunnelUtils;
import org.apache.seatunnel.common.config.Common;
import org.apache.seatunnel.core.starter.Starter;
import org.apache.seatunnel.core.starter.command.CommandArgs;
import org.apache.seatunnel.core.starter.enums.EngineType;
import org.apache.seatunnel.core.starter.flink.SeaTunnelFlink;
import org.apache.seatunnel.core.starter.flink.args.FlinkCommandArgs;
import org.apache.seatunnel.core.starter.utils.CommandLineUtils;

public class FlinkV2Starter
implements Starter {
    public static final Log logger = LogFactory.getLog((String)FlinkV2Starter.class.getName());
    private static final String APP_NAME = SeaTunnelFlink.class.getName();
    private static final String APP_JAR_NAME = EngineType.FLINK13.getStarterJarName();
    private static final String SHELL_NAME = EngineType.FLINK13.getStarterShellName();
    private final FlinkCommandArgs flinkCommandArgs;
    private final String appJar;

    FlinkV2Starter(String[] args) {
        this.flinkCommandArgs = (FlinkCommandArgs)CommandLineUtils.parse((String[])args, (CommandArgs)new FlinkCommandArgs(), (String)SHELL_NAME, (boolean)true);
        logger.info((Object)("this.flinkCommandArgs = " + this.flinkCommandArgs));
        Common.setDeployMode(this.flinkCommandArgs.getDeployMode());
        Common.setStarter(true);
        this.appJar = Common.appStarterDir().resolve(APP_JAR_NAME).toString();
    }

    public static int main(String[] args) {
        logger.info((Object)("FlinkStarter start:" + Arrays.toString(args)));
        int exitCode = 0;
        try {
            FlinkV2Starter flinkStarter = new FlinkV2Starter(args);
            String commandVal = String.join((CharSequence)" ", flinkStarter.buildCommands());
            logger.info((Object)("FlinkV2Starter commandVal:" + commandVal));
            exitCode = SeatunnelUtils.executeLine(commandVal);
        }
        catch (Exception e) {
            exitCode = 1;
            logger.error((Object)("\n\nFlinkV2Starter error:\n" + e));
        }
        return exitCode;
    }

    public List<String> buildCommands() {
        ArrayList<String> command = new ArrayList<String>();
        command.add("${FLINK_HOME}/bin/flink");
        command.add(this.flinkCommandArgs.getDeployMode().getDeployMode());
        if (this.flinkCommandArgs.getMasterType() != null) {
            command.add("--target");
            command.add(this.flinkCommandArgs.getMasterType().getMaster());
        }
        logger.info((Object)("FlinkV2Starter OriginalParameters:" + this.flinkCommandArgs.getOriginalParameters()));
        command.add("-c");
        command.add(APP_NAME);
        command.add(this.appJar);
        command.add("--config");
        command.add(this.flinkCommandArgs.getConfigFile());
        command.add("--name");
        command.add(this.flinkCommandArgs.getJobName());
        this.flinkCommandArgs.getVariables().stream().filter(Objects::nonNull).map(String::trim).forEach(variable -> command.add("-D" + variable));
        return command;
    }
}

