/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seatunnel.common.config;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.linkis.engineconnplugin.seatunnel.client.exception.JobExecutionException;
import org.apache.seatunnel.common.config.DeployMode;

public class Common {
    public static final Log logger = LogFactory.getLog((String)Common.class.getName());
    public static final int COLLECTION_SIZE = 16;
    private static final int APP_LIB_DIR_DEPTH = 2;
    private static final int PLUGIN_LIB_DIR_DEPTH = 3;
    private static DeployMode MODE;
    private static String SEATUNNEL_HOME;
    private static boolean STARTER;

    private Common() {
        throw new IllegalStateException("Utility class");
    }

    public static void setDeployMode(DeployMode mode) {
        MODE = mode;
    }

    public static void setStarter(boolean inStarter) {
        STARTER = inStarter;
    }

    public static DeployMode getDeployMode() {
        return MODE;
    }

    public static Path appStarterDir() {
        return Common.appRootDir().resolve("starter");
    }

    private static String getSeaTunnelHome() {
        if (StringUtils.isNotEmpty((CharSequence)SEATUNNEL_HOME)) {
            return SEATUNNEL_HOME;
        }
        String seatunnelHome = System.getProperty("SEATUNNEL_HOME");
        if (StringUtils.isBlank((CharSequence)seatunnelHome)) {
            seatunnelHome = System.getenv("SEATUNNEL_HOME");
        }
        if (StringUtils.isBlank((CharSequence)seatunnelHome)) {
            seatunnelHome = Common.appRootDir().toString();
        }
        SEATUNNEL_HOME = seatunnelHome;
        return SEATUNNEL_HOME;
    }

    public static Path appRootDir() {
        logger.info((Object)("Mode:" + MODE + ",Starter:" + STARTER));
        if (DeployMode.CLIENT == MODE || DeployMode.RUN == MODE || STARTER) {
            try {
                String path = System.getProperty("SEATUNNEL_HOME") + "/seatunnel";
                path = new File(path).getPath();
                logger.info((Object)("appRootDir:" + path));
                return Paths.get(path, new String[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        if (DeployMode.CLUSTER == MODE || DeployMode.RUN_APPLICATION == MODE) {
            return Paths.get("", new String[0]);
        }
        throw new IllegalStateException("deploy mode not support : " + MODE);
    }

    public static Path appLibDir() {
        return Common.appRootDir().resolve("lib");
    }

    public static Path pluginRootDir() {
        return Paths.get(Common.appRootDir().toString(), "plugins");
    }

    public static Path connectorRootDir(String engine) {
        return Paths.get(Common.appRootDir().toString(), "connectors", engine.toLowerCase());
    }

    public static Path connectorJarDir(String engine) {
        return Paths.get(Common.appRootDir().toString(), "connectors", engine.toLowerCase());
    }

    public static Path connectorDir() {
        return Paths.get(Common.appRootDir().toString(), "connectors");
    }

    public static Path pluginTarball() {
        return Common.appRootDir().resolve("plugins.tar.gz");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> getPluginsJarDependencies() {
        Path pluginRootDir = Common.pluginRootDir();
        if (!Files.exists(pluginRootDir, new LinkOption[0])) return Collections.emptyList();
        if (!Files.isDirectory(pluginRootDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.walk(pluginRootDir, 3, FileVisitOption.FOLLOW_LINKS);){
            List<Path> list = stream.filter(it -> pluginRootDir.relativize((Path)it).getNameCount() == 3).filter(it -> it.getParent().endsWith("lib")).filter(it -> it.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new JobExecutionException(e.getMessage(), e);
        }
    }

    public static Path libDir() {
        return Common.appRootDir().resolve("lib");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static List<Path> getLibJars() {
        Path libRootDir = Common.libDir();
        if (!Files.exists(libRootDir, new LinkOption[0])) return Collections.emptyList();
        if (!Files.isDirectory(libRootDir, new LinkOption[0])) {
            return Collections.emptyList();
        }
        try (Stream<Path> stream = Files.walk(libRootDir, 2, FileVisitOption.FOLLOW_LINKS);){
            List<Path> list = stream.filter(it -> !it.toFile().isDirectory()).filter(it -> it.getFileName().toString().endsWith(".jar")).collect(Collectors.toList());
            return list;
        }
        catch (IOException e) {
            throw new JobExecutionException(e.getMessage(), e);
        }
    }

    public static Set<Path> getThirdPartyJars(String paths) {
        logger.info((Object)("getThirdPartyJars path:" + paths));
        return Arrays.stream(paths.split(";")).filter(s -> !"".equals(s)).filter(it -> it.endsWith(".jar")).map(path -> Paths.get(URI.create(path))).collect(Collectors.toSet());
    }

    static {
        STARTER = false;
    }
}

