/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.pipeline.executor;

import java.io.Closeable;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.linkis.common.io.Fs;
import org.apache.linkis.common.io.FsPath;
import org.apache.linkis.common.io.FsWriter;
import org.apache.linkis.common.utils.ResultSetUtils;
import org.apache.linkis.engineconn.computation.executor.execute.EngineExecutionContext;
import org.apache.linkis.manager.engineplugin.pipeline.conf.PipelineEngineConfiguration$;
import org.apache.linkis.manager.engineplugin.pipeline.constant.PipeLineConstant$;
import org.apache.linkis.manager.engineplugin.pipeline.errorcode.PopelineErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.pipeline.exception.PipeLineErrorException;
import org.apache.linkis.manager.engineplugin.pipeline.executor.ExcelExecutor$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.OutputStreamCache$;
import org.apache.linkis.manager.engineplugin.pipeline.executor.PipeLineExecutor;
import org.apache.linkis.scheduler.executer.ExecuteResponse;
import org.apache.linkis.storage.FSFactory$;
import org.apache.linkis.storage.domain.FsPathListWithError;
import org.apache.linkis.storage.excel.ExcelFsWriter$;
import org.apache.linkis.storage.excel.StorageMultiExcelWriter;
import org.apache.linkis.storage.fs.FileSystem;
import org.apache.linkis.storage.source.FileSource;
import org.apache.linkis.storage.source.FileSource$;
import scala.Array$;
import scala.Function1;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableLike;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.Map$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001a3AAC\u0006\u00015!)Q\u0005\u0001C\u0001M!)\u0001\u0006\u0001C!S!)Q\n\u0001C!\u001d\u001e)qj\u0003E\u0001!\u001a)!b\u0003E\u0001#\")Q%\u0002C\u0001%\"91+\u0002b\u0001\n\u0003!\u0006BB+\u0006A\u0003%q\u0005C\u0003W\u000b\u0011\u0005qKA\u0007Fq\u000e,G.\u0012=fGV$xN\u001d\u0006\u0003\u00195\t\u0001\"\u001a=fGV$xN\u001d\u0006\u0003\u001d=\t\u0001\u0002]5qK2Lg.\u001a\u0006\u0003!E\tA\"\u001a8hS:,\u0007\u000f\\;hS:T!AE\n\u0002\u000f5\fg.Y4fe*\u0011A#F\u0001\u0007Y&t7.[:\u000b\u0005Y9\u0012AB1qC\u000eDWMC\u0001\u0019\u0003\ry'oZ\u0002\u0001'\r\u00011$\t\t\u00039}i\u0011!\b\u0006\u0002=\u0005)1oY1mC&\u0011\u0001%\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\t\u001aS\"A\u0006\n\u0005\u0011Z!\u0001\u0005)ja\u0016d\u0015N\\3Fq\u0016\u001cW\u000f^8s\u0003\u0019a\u0014N\\5u}Q\tq\u0005\u0005\u0002#\u0001\u00059Q\r_3dkR,G\u0003\u0002\u00163\u007f\u0005\u0003\"a\u000b\u0019\u000e\u00031R!!\f\u0018\u0002\u0011\u0015DXmY;uKJT!aL\n\u0002\u0013M\u001c\u0007.\u001a3vY\u0016\u0014\u0018BA\u0019-\u0005=)\u00050Z2vi\u0016\u0014Vm\u001d9p]N,\u0007\"B\u001a\u0003\u0001\u0004!\u0014AC:pkJ\u001cW\rU1uQB\u0011Q\u0007\u0010\b\u0003mi\u0002\"aN\u000f\u000e\u0003aR!!O\r\u0002\rq\u0012xn\u001c;?\u0013\tYT$\u0001\u0004Qe\u0016$WMZ\u0005\u0003{y\u0012aa\u0015;sS:<'BA\u001e\u001e\u0011\u0015\u0001%\u00011\u00015\u0003!!Wm\u001d;QCRD\u0007\"\u0002\"\u0003\u0001\u0004\u0019\u0015!F3oO&tW-\u0012=fGV$xN]\"p]R,\u0007\u0010\u001e\t\u0003\t.k\u0011!\u0012\u0006\u0003Q\u0019S!\u0001D$\u000b\u0005!K\u0015aC2p[B,H/\u0019;j_:T!AS\n\u0002\u0015\u0015tw-\u001b8fG>tg.\u0003\u0002M\u000b\n1RI\\4j]\u0016,\u00050Z2vi&|gnQ8oi\u0016DH/\u0001\u0003LS:$W#\u0001\u001b\u0002\u001b\u0015C8-\u001a7Fq\u0016\u001cW\u000f^8s!\t\u0011Sa\u0005\u0002\u00067Q\t\u0001+A\u0007fq\u000e,G.\u0012=fGV$xN]\u000b\u0002O\u0005qQ\r_2fY\u0016CXmY;u_J\u0004\u0013aC4fi&s7\u000f^1oG\u0016,\u0012!\t")
public class ExcelExecutor
implements PipeLineExecutor {
    private Map<String, String> options;

    public static PipeLineExecutor getInstance() {
        return ExcelExecutor$.MODULE$.getInstance();
    }

    public static ExcelExecutor excelExecutor() {
        return ExcelExecutor$.MODULE$.excelExecutor();
    }

    @Override
    public void init(Map<String, String> newOptions) {
        PipeLineExecutor.init$(this, newOptions);
    }

    @Override
    public void cleanOptions() {
        PipeLineExecutor.cleanOptions$(this);
    }

    @Override
    public Map<String, String> options() {
        return this.options;
    }

    @Override
    public void options_$eq(Map<String, String> x$1) {
        this.options = x$1;
    }

    @Override
    public ExecuteResponse execute(String sourcePath, String destPath, EngineExecutionContext engineExecutorContext) {
        FileSource fileSource = null;
        StorageMultiExcelWriter excelFsWriter = null;
        FsPath sourceFsPath = new FsPath(sourcePath);
        FsPath destFsPath = new FsPath(destPath);
        Fs sourceFs = FSFactory$.MODULE$.getFs(sourceFsPath);
        sourceFs.init(null);
        Fs destFs = FSFactory$.MODULE$.getFs(destFsPath);
        destFs.init(null);
        OutputStream outputStream = destFs.write(destFsPath, BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.PIPELINE_OUTPUT_ISOVERWRITE_SWITCH().getValue(this.options())));
        HashMap paramsMap = new HashMap();
        ((IterableLike)((TraversableLike)((TraversableLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(engineExecutorContext.getProperties()).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExcelExecutor.$anonfun$execute$1(x$1)))).map((Function1 & Serializable & scala.Serializable)kv -> new Tuple2(kv._1(), (Object)kv._2().toString()), Map$.MODULE$.canBuildFrom())).foreach((Function1 & Serializable & scala.Serializable)kv -> (String)paramsMap.put(kv._1(), kv._2()));
        boolean excelAutoFormat = BoxesRunTime.unboxToBoolean((Object)PipelineEngineConfiguration$.MODULE$.EXPORT_EXCEL_AUTO_FORMAT().getValue(paramsMap));
        if (sourcePath.contains(".")) {
            if (!FileSource$.MODULE$.isResultSet(sourcePath)) {
                throw new PipeLineErrorException(PopelineErrorCodeSummary.NOT_A_RESULT_SET_FILE.getErrorCode(), PopelineErrorCodeSummary.NOT_A_RESULT_SET_FILE.getErrorDesc());
            }
            fileSource = FileSource$.MODULE$.create(sourceFsPath, sourceFs);
            excelFsWriter = ExcelFsWriter$.MODULE$.getExcelFsWriter(PipeLineConstant$.MODULE$.DEFAULTC_HARSET(), PipeLineConstant$.MODULE$.DEFAULT_SHEETNAME(), PipeLineConstant$.MODULE$.DEFAULT_DATEFORMATE(), outputStream, excelAutoFormat);
        } else {
            excelFsWriter = new StorageMultiExcelWriter(outputStream, excelAutoFormat);
            FsPathListWithError fsPathListWithError = ((FileSystem)sourceFs).listPathWithError(sourceFsPath);
            if (fsPathListWithError == null) {
                throw new PipeLineErrorException(PopelineErrorCodeSummary.EMPTY_DIR.getErrorCode(), PopelineErrorCodeSummary.EMPTY_DIR.getErrorDesc());
            }
            List fsPathList = fsPathListWithError.getFsPaths();
            ResultSetUtils.sortByNameNum((List)fsPathList);
            fileSource = FileSource$.MODULE$.create((FsPath[])fsPathList.toArray((Object[])Array$.MODULE$.apply((Seq)Nil$.MODULE$, ClassTag$.MODULE$.apply(FsPath.class))), sourceFs);
        }
        if (!FileSource$.MODULE$.isTableResultSet(fileSource)) {
            throw new PipeLineErrorException(PopelineErrorCodeSummary.ONLY_RESULT_CONVERTED_TO_EXCEL.getErrorCode(), PopelineErrorCodeSummary.ONLY_RESULT_CONVERTED_TO_EXCEL.getErrorDesc());
        }
        String nullValue = this.options().getOrDefault(PipeLineConstant$.MODULE$.PIPELINE_OUTPUT_SHUFFLE_NULL_TYPE(), "NULL");
        if (PipeLineConstant$.MODULE$.BLANK().equalsIgnoreCase(nullValue)) {
            nullValue = "";
        }
        OutputStreamCache$.MODULE$.osCache().put((String)engineExecutorContext.getJobId().get(), outputStream);
        fileSource.addParams("nullValue", nullValue).write((FsWriter)excelFsWriter);
        IOUtils.closeQuietly((Closeable)excelFsWriter);
        IOUtils.closeQuietly((Closeable)fileSource);
        IOUtils.closeQuietly((Closeable)sourceFs);
        IOUtils.closeQuietly((Closeable)destFs);
        return PipeLineExecutor.execute$(this, sourcePath, destPath, engineExecutorContext);
    }

    @Override
    public String Kind() {
        return "xlsx";
    }

    public static final /* synthetic */ boolean $anonfun$execute$1(Tuple2 x$1) {
        return x$1._2() != null;
    }

    public ExcelExecutor() {
        PipeLineExecutor.$init$(this);
    }
}

