/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.jdbc.executor;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import org.apache.linkis.storage.domain.ArrayType;
import org.apache.linkis.storage.domain.BinaryType;
import org.apache.linkis.storage.domain.BooleanType;
import org.apache.linkis.storage.domain.CharType;
import org.apache.linkis.storage.domain.DateType;
import org.apache.linkis.storage.domain.DecimalType;
import org.apache.linkis.storage.domain.DoubleType;
import org.apache.linkis.storage.domain.FloatType;
import org.apache.linkis.storage.domain.IntType;
import org.apache.linkis.storage.domain.LongType;
import org.apache.linkis.storage.domain.NullType;
import org.apache.linkis.storage.domain.ShortIntType;
import org.apache.linkis.storage.domain.StringType;
import org.apache.linkis.storage.domain.StructType;
import org.apache.linkis.storage.domain.TimestampType;
import org.apache.linkis.storage.domain.TinyIntType;

public class JDBCHelper {
    protected String helper(ResultSet rs, int dataType, int col) throws SQLException {
        String retVal = null;
        switch (dataType) {
            case 91: {
                Date date = rs.getDate(col);
                retVal = date.toString();
                break;
            }
            case 92: {
                Time time = rs.getTime(col);
                retVal = time.toString();
                break;
            }
            case 93: {
                Timestamp timestamp = rs.getTimestamp(col);
                retVal = timestamp.toString();
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                retVal = rs.getString(col);
                break;
            }
            case 2: 
            case 3: {
                BigDecimal numeric = rs.getBigDecimal(col, 10);
                retVal = numeric.toString();
                break;
            }
            case -7: {
                boolean bit = rs.getBoolean(col);
                Boolean boolObj = new Boolean(bit);
                retVal = boolObj.toString();
                break;
            }
            case -6: {
                byte tinyint = rs.getByte(col);
                Integer intObj = new Integer(tinyint);
                retVal = intObj.toString();
                break;
            }
            case 5: {
                short smallint = rs.getShort(col);
                Integer intObj = new Integer(smallint);
                retVal = intObj.toString();
                break;
            }
            case 4: {
                int integer = rs.getInt(col);
                Integer intObj = new Integer(integer);
                retVal = intObj.toString();
                break;
            }
            case -5: {
                long bigint = rs.getLong(col);
                Long longObj = new Long(bigint);
                retVal = longObj.toString();
                break;
            }
            case 7: {
                float real = rs.getFloat(col);
                Float floatObj = new Float(real);
                retVal = floatObj.toString();
                break;
            }
            case 6: 
            case 8: {
                double longreal = rs.getDouble(col);
                Double doubleObj = new Double(longreal);
                retVal = doubleObj.toString();
                break;
            }
            case -4: 
            case -3: 
            case -2: {
                byte[] binary = rs.getBytes(col);
                retVal = new String(binary);
                break;
            }
        }
        return retVal;
    }

    public static String getTypeStr(int type) {
        String retVal = null;
        switch (type) {
            case 0: {
                retVal = NullType.typeName();
                break;
            }
            case 12: {
                retVal = StringType.typeName();
                break;
            }
            case 16: {
                retVal = BooleanType.typeName();
                break;
            }
            case -6: {
                retVal = TinyIntType.typeName();
                break;
            }
            case 5: {
                retVal = ShortIntType.typeName();
                break;
            }
            case 4: {
                retVal = IntType.typeName();
                break;
            }
            case -16: {
                retVal = LongType.typeName();
                break;
            }
            case -1: {
                retVal = StringType.typeName();
                break;
            }
            case 6: {
                retVal = FloatType.typeName();
                break;
            }
            case 8: {
                retVal = DoubleType.typeName();
                break;
            }
            case 1: {
                retVal = CharType.typeName();
                break;
            }
            case 91: {
                retVal = DateType.typeName();
                break;
            }
            case 93: {
                retVal = TimestampType.typeName();
                break;
            }
            case -2: {
                retVal = BinaryType.typeName();
                break;
            }
            case 3: {
                retVal = DecimalType.typeName();
                break;
            }
            case 2003: {
                retVal = ArrayType.typeName();
                break;
            }
            case 2002: {
                retVal = StructType.typeName();
                break;
            }
            case -5: {
                retVal = LongType.typeName();
                break;
            }
            case 7: {
                retVal = DoubleType.typeName();
                break;
            }
        }
        return retVal;
    }
}

