/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineplugin.elasticsearch.executor.client;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.EncodingUtils;
import org.apache.linkis.engineplugin.elasticsearch.conf.ElasticSearchConfiguration;
import org.apache.linkis.engineplugin.elasticsearch.executor.client.EsClient;
import org.elasticsearch.client.Cancellable;
import org.elasticsearch.client.Request;
import org.elasticsearch.client.RequestOptions;
import org.elasticsearch.client.ResponseListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.client.sniff.Sniffer;

public class EsClientImpl
extends EsClient {
    public EsClientImpl(String datasourceName, RestClient client, Sniffer sniffer) {
        super(datasourceName, client, sniffer);
    }

    @Override
    public Cancellable execute(String code, Map<String, String> options, ResponseListener responseListener) {
        Request request = this.createRequest(code, options);
        return this.client.performRequestAsync(request, responseListener);
    }

    private Request createRequest(String code, Map<String, String> options) {
        String endpoint = (String)ElasticSearchConfiguration.ES_HTTP_ENDPOINT.getValue(options);
        String method = (String)ElasticSearchConfiguration.ES_HTTP_METHOD.getValue(options);
        Request request = new Request(method, endpoint);
        request.setOptions(this.getRequestOptions(options));
        request.setJsonEntity(code);
        return request;
    }

    private RequestOptions getRequestOptions(Map<String, String> options) {
        RequestOptions.Builder builder = RequestOptions.DEFAULT.toBuilder();
        String username = (String)ElasticSearchConfiguration.ES_USERNAME.getValue(options);
        String password = (String)ElasticSearchConfiguration.ES_PASSWORD.getValue(options);
        if (StringUtils.isNotBlank((CharSequence)username) && StringUtils.isNotBlank((CharSequence)password)) {
            Header authHeader = this.authenticate((Credentials)new UsernamePasswordCredentials(username, password), StandardCharsets.UTF_8.name());
            builder.addHeader(authHeader.getName(), authHeader.getValue());
        }
        options.entrySet().stream().filter(entry -> entry.getKey() != null && entry.getValue() != null && ((String)entry.getKey()).startsWith("linkis.es.headers.")).forEach(entry -> builder.addHeader((String)entry.getKey(), (String)entry.getValue()));
        return builder.build();
    }

    private Header authenticate(Credentials credentials, String charset) {
        StringBuilder tmp = new StringBuilder();
        tmp.append(credentials.getUserPrincipal().getName());
        tmp.append(":");
        tmp.append(credentials.getPassword() == null ? "null" : credentials.getPassword());
        byte[] base64password = Base64.encodeBase64((byte[])EncodingUtils.getBytes((String)tmp.toString(), (String)charset), (boolean)false);
        CharArrayBuffer buffer = new CharArrayBuffer(32);
        buffer.append("Authorization");
        buffer.append(": Basic ");
        buffer.append(base64password, 0, base64password.length);
        return new BufferedHeader(buffer);
    }
}

