/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.manager.engineplugin.hbase.shell;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.manager.engineplugin.hbase.errorcode.HBaseErrorCodeSummary;
import org.apache.linkis.manager.engineplugin.hbase.exception.ExecutorInitException;
import org.apache.linkis.manager.engineplugin.hbase.shell.Result;
import org.apache.linkis.manager.engineplugin.hbase.shell.ShellSession;
import org.jruby.embed.LocalContextScope;
import org.jruby.embed.ScriptingContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HBaseShellSession
implements ShellSession {
    private static final Logger LOGGER = LoggerFactory.getLogger(HBaseShellSession.class);
    private static final String SESSION_PROP_SEPARATOR = "$";
    private final String sessionId;
    private final int sessionInitMaxTimes;
    private final long sessionInitRetryInterval;
    private final long sessionInitTimeout;
    private final long sessionIdle;
    private final long sessionInitStartTime;
    private final boolean sessionDebugLog;
    private final Map<String, String> properties;
    private ScriptingContainer scriptingContainer;
    private StringWriter writer;
    private boolean isConnected;

    public HBaseShellSession(Builder builder) {
        this.properties = builder.properties;
        this.sessionId = builder.sessionId;
        this.sessionInitMaxTimes = builder.sessionInitMaxTimes;
        this.sessionInitRetryInterval = builder.sessionInitRetryInterval;
        this.sessionInitTimeout = builder.sessionInitTimeout;
        this.sessionIdle = builder.sessionIdle;
        this.sessionInitStartTime = System.currentTimeMillis();
        this.sessionDebugLog = builder.sessionDebugLog;
    }

    public static Builder sessionBuilder() {
        return new Builder();
    }

    @Override
    public void open() {
        Thread t = new Thread(() -> {
            int initMaxTimes = this.getSessionInitMaxTimes();
            try {
                LOGGER.info("Starting create hbase shell session ......");
                this.createShellRunningEnv();
            }
            catch (Exception e) {
                LOGGER.error("error: ", (Throwable)e);
                for (int i = 0; i < initMaxTimes; ++i) {
                    try {
                        this.createShellRunningEnv();
                        continue;
                    }
                    catch (Exception ex) {
                        if (i == initMaxTimes - 1) {
                            LOGGER.error("After {} retries, HBase shell session initialization failed.", (Object)initMaxTimes, (Object)ex);
                            throw new ExecutorInitException(HBaseErrorCodeSummary.HBASE_SHELL_ENV_INIT_FAILED.getErrorCode(), HBaseErrorCodeSummary.HBASE_SHELL_ENV_INIT_FAILED.getErrorDesc());
                        }
                        this.shortSpin(this.getSessionInitRetryInterval());
                    }
                }
            }
        });
        t.setName("HBaseShellRunningEnvInitThread");
        t.setDaemon(true);
        t.start();
        this.shortSpin(10000L);
        CompletableFuture<Boolean> future = CompletableFuture.supplyAsync(this::waitShellSessionConnected);
        try {
            this.isConnected = future.get(this.getSessionInitTimeout(), TimeUnit.MILLISECONDS);
            LOGGER.info("Created hbase shell session successfully.");
        }
        catch (InterruptedException | ExecutionException e) {
            this.isConnected = false;
            future.cancel(true);
            LOGGER.error("Initialize hbase shell session failed.", (Throwable)e);
            this.destroy();
        }
        catch (TimeoutException e) {
            LOGGER.error("Initialize hbase shell session timeout.", (Throwable)e);
            this.isConnected = false;
            future.cancel(true);
            this.destroy();
        }
    }

    private void shortSpin(long interval) {
        if (interval <= 0L) {
            return;
        }
        try {
            Thread.sleep(interval);
        }
        catch (InterruptedException e) {
            LOGGER.warn("Ignore error.", (Throwable)e);
        }
    }

    private void createShellRunningEnv() throws IOException {
        this.scriptingContainer = new ScriptingContainer(LocalContextScope.SINGLETHREAD);
        this.writer = new StringWriter();
        this.scriptingContainer.setOutput((Writer)this.writer);
        Properties sysProps = System.getProperties();
        String prop = "";
        if (this.isSessionDebugLog()) {
            prop = "-d".concat(SESSION_PROP_SEPARATOR);
        }
        if (this.properties != null && !this.properties.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            for (String key : this.properties.keySet()) {
                sb.append("-D");
                sb.append(key);
                sb.append("=");
                sb.append(this.properties.get(key));
                sb.append(SESSION_PROP_SEPARATOR);
            }
            prop = prop + sb.substring(0, sb.length() - 1);
        }
        if (StringUtils.isNotBlank((CharSequence)prop)) {
            sysProps.setProperty("hbase.ruby.args", prop);
        }
        InputStream in = this.getClass().getClassLoader().getResourceAsStream("hbase-ruby/hirb.rb");
        Object object = null;
        try {
            this.scriptingContainer.runScriptlet(in, "hirb.rb");
        }
        catch (Throwable throwable) {
            object = throwable;
            throw throwable;
        }
        finally {
            if (in != null) {
                if (object != null) {
                    try {
                        in.close();
                    }
                    catch (Throwable throwable) {
                        ((Throwable)object).addSuppressed(throwable);
                    }
                } else {
                    in.close();
                }
            }
        }
    }

    private boolean waitShellSessionConnected() {
        while (true) {
            Result result = this.executeCmd("list_namespace");
            String r = result.getResult();
            if (result.isSuccess() && StringUtils.isNotBlank((CharSequence)r)) {
                return true;
            }
            this.shortSpin(200L);
        }
    }

    @Override
    public Result execute(String cmd) {
        if (!this.isConnected()) {
            String errorMsg = String.format("The current hbase shell session [%s] is not connected successfully, please try again.", this);
            return Result.failed(errorMsg, (Throwable)((Object)new ExecutorInitException(HBaseErrorCodeSummary.HBASE_SHELL_ENV_INIT_FAILED.getErrorCode(), HBaseErrorCodeSummary.HBASE_SHELL_ENV_INIT_FAILED.getErrorDesc())));
        }
        return this.executeCmd(cmd);
    }

    @Override
    public void destroy() {
        if (!this.isConnected()) {
            LOGGER.info("The hbase shell session has closed.");
        }
        if (this.scriptingContainer != null) {
            this.scriptingContainer.terminate();
        }
        this.setConnected(false);
        LOGGER.info("The hbase shell session destroy successfully.");
    }

    private Result executeCmd(String cmd) {
        try {
            this.writer.getBuffer().setLength(0);
            Object o = this.scriptingContainer.runScriptlet(cmd);
            this.writer.flush();
            String res = this.writer.toString();
            if (StringUtils.isBlank((CharSequence)res) && o != null) {
                res = o.toString();
            }
            if (res.contains("ERROR: ") && res.contains("For usage try 'help")) {
                return Result.failed(this.getStackTrace(new Throwable(new Exception(res))), new Exception(res));
            }
            return Result.ok(res);
        }
        catch (Exception e) {
            return Result.failed(this.getStackTrace(e), e);
        }
    }

    public String getStackTrace(Throwable throwable) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter((Writer)sw, true);
        throwable.printStackTrace(pw);
        return sw.getBuffer().toString();
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public Map<String, String> getProperties() {
        return this.properties;
    }

    public int getSessionInitMaxTimes() {
        return this.sessionInitMaxTimes;
    }

    public long getSessionInitRetryInterval() {
        return this.sessionInitRetryInterval;
    }

    public long getSessionInitTimeout() {
        return this.sessionInitTimeout;
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    public void setConnected(boolean connected) {
        this.isConnected = connected;
    }

    public long getSessionIdle() {
        return this.sessionIdle;
    }

    public long getSessionInitStartTime() {
        return this.sessionInitStartTime;
    }

    public boolean isSessionDebugLog() {
        return this.sessionDebugLog;
    }

    public String toString() {
        return this.getSessionId();
    }

    static class Builder {
        private String sessionId;
        private Map<String, String> properties;
        private int sessionInitMaxTimes;
        private long sessionInitRetryInterval;
        private long sessionInitTimeout;
        private long sessionIdle;
        private boolean sessionDebugLog;

        Builder() {
        }

        public Builder sessionId(String sessionId) {
            this.sessionId = sessionId;
            return this;
        }

        public Builder properties(Map<String, String> properties) {
            this.properties = properties;
            return this;
        }

        public Builder sessionInitMaxTimes(int sessionInitMaxTimes) {
            this.sessionInitMaxTimes = sessionInitMaxTimes;
            return this;
        }

        public Builder sessionInitRetryInterval(long sessionInitRetryInterval) {
            this.sessionInitRetryInterval = sessionInitRetryInterval;
            return this;
        }

        public Builder sessionInitTimeout(long sessionInitTimeout) {
            this.sessionInitTimeout = sessionInitTimeout;
            return this;
        }

        public Builder sessionIdle(long sessionIdle) {
            this.sessionIdle = sessionIdle;
            return this;
        }

        public Builder sessionDebugLog(boolean sessionDebugLog) {
            this.sessionDebugLog = sessionDebugLog;
            return this;
        }

        public Builder properties(String key, String value) {
            if (this.properties == null) {
                this.properties = new HashMap<String, String>();
            }
            this.properties.put(key, value);
            return this;
        }

        public HBaseShellSession build() {
            return new HBaseShellSession(this);
        }
    }
}

