/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.operator.clientmanager;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.cache.RemovalListener;
import com.google.common.cache.RemovalNotification;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import org.apache.flink.client.program.rest.RestClusterClient;
import org.apache.flink.configuration.Configuration;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.hadoop.yarn.api.records.ApplicationReport;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconnplugin.flink.config.FlinkEnvConfiguration$;
import org.apache.linkis.engineconnplugin.flink.executor.interceptor.FlinkManagerConcurrentExecutor;
import org.apache.linkis.engineconnplugin.flink.factory.FlinkManagerExecutorFactory$;
import org.apache.linkis.engineconnplugin.flink.util.YarnUtil$;
import org.slf4j.Logger;
import scala.Function0;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class FlinkRestClientManager$
implements Logging {
    public static FlinkRestClientManager$ MODULE$;
    private LoadingCache<String, RestClusterClient<ApplicationId>> restclientCache;
    private Logger logger;
    private volatile byte bitmap$0;

    static {
        new FlinkRestClientManager$();
    }

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    private Logger logger$lzycompute() {
        FlinkRestClientManager$ flinkRestClientManager$ = this;
        synchronized (flinkRestClientManager$) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if ((byte)(this.bitmap$0 & 2) == 0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private LoadingCache<String, RestClusterClient<ApplicationId>> restclientCache$lzycompute() {
        FlinkRestClientManager$ flinkRestClientManager$ = this;
        synchronized (flinkRestClientManager$) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.restclientCache = CacheBuilder.newBuilder().maximumSize((long)BoxesRunTime.unboxToInt((Object)FlinkEnvConfiguration$.MODULE$.FLINK_MANAGER_CLIENT_MAX_NUM().getValue())).expireAfterAccess((long)BoxesRunTime.unboxToInt((Object)FlinkEnvConfiguration$.MODULE$.FLINK_MANAGER_CLIENT_EXPIRE_MILLS().getValue()), TimeUnit.MILLISECONDS).weakKeys().removalListener((RemovalListener)new RemovalListener<String, RestClusterClient<ApplicationId>>(){

                    public void onRemoval(RemovalNotification<String, RestClusterClient<ApplicationId>> notification) {
                        FlinkRestClientManager$.MODULE$.logger().info(new StringBuilder(42).append("RestClusterClient of AppId : ").append(notification.getKey()).append(" was removed.").toString());
                    }
                }).build((CacheLoader)new CacheLoader<String, RestClusterClient<ApplicationId>>(){

                    public RestClusterClient<ApplicationId> load(String appIdStr) {
                        ApplicationId appId = YarnUtil$.MODULE$.retrieveApplicationId(appIdStr);
                        YarnClient yarnClient = YarnUtil$.MODULE$.getYarnClient();
                        ApplicationReport appReport = yarnClient.getApplicationReport(appId);
                        FinalApplicationStatus finalApplicationStatus = appReport.getFinalApplicationStatus();
                        FinalApplicationStatus finalApplicationStatus2 = FinalApplicationStatus.UNDEFINED;
                        if (finalApplicationStatus == null ? finalApplicationStatus2 != null : !finalApplicationStatus.equals(finalApplicationStatus2)) {
                            String msg = new StringBuilder(85).append("The application ").append(appIdStr).append(" doesn't run anymore. It has previously completed with final status: ").append(appReport.getFinalApplicationStatus().toString()).toString();
                            throw YarnUtil$.MODULE$.logAndException(msg, YarnUtil$.MODULE$.logAndException$default$2());
                        }
                        FlinkManagerConcurrentExecutor executor = FlinkManagerExecutorFactory$.MODULE$.getDefaultExecutor();
                        FlinkManagerConcurrentExecutor flinkManagerConcurrentExecutor = executor;
                        if (!(flinkManagerConcurrentExecutor instanceof org.apache.linkis.engineconnplugin.flink.executor.FlinkManagerConcurrentExecutor)) {
                            String msg = new StringBuilder(41).append("Invalid FlinkManagerConcurrentExecutor : ").append(executor).toString();
                            throw YarnUtil$.MODULE$.logAndException(msg, YarnUtil$.MODULE$.logAndException$default$2());
                        }
                        FlinkManagerConcurrentExecutor flinkManagerConcurrentExecutor2 = flinkManagerConcurrentExecutor;
                        Configuration tmpFlinkConf = ((org.apache.linkis.engineconnplugin.flink.executor.FlinkManagerConcurrentExecutor)((Object)flinkManagerConcurrentExecutor2)).getFlinkContext().getEnvironmentContext().getFlinkConfig().clone();
                        YarnUtil$.MODULE$.setClusterEntrypointInfoToConfig(tmpFlinkConf, appReport);
                        return new RestClusterClient(tmpFlinkConf, (Object)appReport.getApplicationId());
                    }
                });
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.restclientCache;
    }

    private LoadingCache<String, RestClusterClient<ApplicationId>> restclientCache() {
        if ((byte)(this.bitmap$0 & 1) == 0) {
            return this.restclientCache$lzycompute();
        }
        return this.restclientCache;
    }

    public RestClusterClient<ApplicationId> getFlinkRestClient(String appIdStr) {
        return (RestClusterClient)this.restclientCache().get((Object)appIdStr);
    }

    public void setFlinkRestClient(String appIdStr, RestClusterClient<ApplicationId> client) {
        this.restclientCache().put((Object)appIdStr, client);
    }

    public void removeFlinkRestClient(String appidStr, RestClusterClient<ApplicationId> client) {
        Utils$.MODULE$.tryAndWarn((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            if (client != null) {
                client.close();
                return;
            }
        }, this.logger());
        this.restclientCache().invalidate((Object)appidStr);
    }

    private FlinkRestClientManager$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
    }
}

