/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.operator;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.yarn.api.records.FinalApplicationStatus;
import org.apache.hadoop.yarn.api.records.YarnApplicationState;
import org.apache.hadoop.yarn.client.api.YarnClient;
import org.apache.linkis.common.utils.Logging;
import org.apache.linkis.common.utils.Utils$;
import org.apache.linkis.engineconn.common.exception.EngineConnException;
import org.apache.linkis.engineconnplugin.flink.util.YarnUtil$;
import org.apache.linkis.governance.common.constant.ec.ECConstants$;
import org.apache.linkis.manager.common.operator.Operator;
import org.apache.linkis.server.BDPJettyServerHelper$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.immutable.Map;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001a3AAB\u0004\u0001)!)1\u0006\u0001C\u0001Y!9q\u0006\u0001b\u0001\n\u0013\u0001\u0004BB\u001f\u0001A\u0003%\u0011\u0007C\u0003?\u0001\u0011\u0005s\bC\u0003O\u0001\u0011\u0005sJ\u0001\u0007MSN$x\n]3sCR|'O\u0003\u0002\t\u0013\u0005Aq\u000e]3sCR|'O\u0003\u0002\u000b\u0017\u0005)a\r\\5oW*\u0011A\"D\u0001\u0011K:<\u0017N\\3d_:t\u0007\u000f\\;hS:T!AD\b\u0002\r1Lgn[5t\u0015\t\u0001\u0012#\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002%\u0005\u0019qN]4\u0004\u0001M!\u0001!F\u000e%!\t1\u0012$D\u0001\u0018\u0015\u0005A\u0012!B:dC2\f\u0017B\u0001\u000e\u0018\u0005\u0019\te.\u001f*fMB\u0011ADI\u0007\u0002;)\u0011\u0001B\b\u0006\u0003?\u0001\naaY8n[>t'BA\u0011\u000e\u0003\u001di\u0017M\\1hKJL!aI\u000f\u0003\u0011=\u0003XM]1u_J\u0004\"!J\u0015\u000e\u0003\u0019R!a\n\u0015\u0002\u000bU$\u0018\u000e\\:\u000b\u0005}i\u0011B\u0001\u0016'\u0005\u001daunZ4j]\u001e\fa\u0001P5oSRtD#A\u0017\u0011\u00059\u0002Q\"A\u0004\u0002\t)\u001cxN\\\u000b\u0002cA\u0011!gO\u0007\u0002g)\u0011A'N\u0001\tI\u0006$\u0018MY5oI*\u0011agN\u0001\bU\u0006\u001c7n]8o\u0015\tA\u0014(A\u0005gCN$XM\u001d=nY*\t!(A\u0002d_6L!\u0001P\u001a\u0003\u0019=\u0013'.Z2u\u001b\u0006\u0004\b/\u001a:\u0002\u000b)\u001cxN\u001c\u0011\u0002\u0011\u001d,GOT1nKN,\u0012\u0001\u0011\t\u0004-\u0005\u001b\u0015B\u0001\"\u0018\u0005\u0015\t%O]1z!\t!5J\u0004\u0002F\u0013B\u0011aiF\u0007\u0002\u000f*\u0011\u0001jE\u0001\u0007yI|w\u000e\u001e \n\u0005);\u0012A\u0002)sK\u0012,g-\u0003\u0002M\u001b\n11\u000b\u001e:j]\u001eT!AS\f\u0002\u000b\u0005\u0004\b\u000f\\=\u0015\u0005A3\u0006\u0003\u0002#R\u0007NK!AU'\u0003\u00075\u000b\u0007\u000f\u0005\u0002\u0017)&\u0011Qk\u0006\u0002\u0004\u0003:L\b\"B,\u0006\u0001\b\u0001\u0016A\u00029be\u0006l7\u000f")
public class ListOperator
implements Operator,
Logging {
    private final ObjectMapper json;
    private Logger logger;
    private volatile boolean bitmap$0;

    public void trace(Function0<String> message) {
        Logging.trace$((Logging)this, message);
    }

    public void debug(Function0<String> message) {
        Logging.debug$((Logging)this, message);
    }

    public void info(Function0<String> message) {
        Logging.info$((Logging)this, message);
    }

    public void info(Function0<String> message, Throwable t) {
        Logging.info$((Logging)this, message, (Throwable)t);
    }

    public void warn(Function0<String> message) {
        Logging.warn$((Logging)this, message);
    }

    public void warn(Function0<String> message, Throwable t) {
        Logging.warn$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message, Throwable t) {
        Logging.error$((Logging)this, message, (Throwable)t);
    }

    public void error(Function0<String> message) {
        Logging.error$((Logging)this, message);
    }

    public <T> T getAs(String key, Function0<T> defaultVal, Map<String, Object> parameters) {
        return (T)Operator.getAs$((Operator)this, (String)key, defaultVal, parameters);
    }

    public <T> T getAsThrow(String key, Map<String, Object> parameters) {
        return (T)Operator.getAsThrow$((Operator)this, (String)key, parameters);
    }

    private Logger logger$lzycompute() {
        ListOperator listOperator = this;
        synchronized (listOperator) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$((Logging)this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    private ObjectMapper json() {
        return this.json;
    }

    public String[] getNames() {
        return (String[])((Object[])new String[]{"list"});
    }

    public Map<String, Object> apply(Map<String, Object> params) {
        HashSet applicationTypeSet = new HashSet();
        ObjectRef appStateSet = ObjectRef.create(EnumSet.of(YarnApplicationState.RUNNING));
        ObjectRef appName = ObjectRef.create((Object)"");
        Utils$.MODULE$.tryCatch((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            List appTypeList = (List)params.getOrElse((Object)ECConstants$.MODULE$.YARN_APP_TYPE_LIST_KEY(), (Function0 & Serializable & scala.Serializable)() -> new ArrayList());
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(appTypeList).asScala()).foreach((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)applicationTypeSet.add(x$1)));
            List appStateList = (List)params.getOrElse((Object)ECConstants$.MODULE$.YARN_APP_STATE_LIST_KEY(), (Function0 & Serializable & scala.Serializable)() -> new ArrayList());
            HashSet appStateArray = new HashSet();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(appStateList).asScala()).foreach((Function1 & Serializable & scala.Serializable)e -> BoxesRunTime.boxToBoolean((boolean)appStateArray.add(YarnApplicationState.valueOf((String)e))));
            if (!appStateArray.isEmpty()) {
                appStateSet$1.elem = EnumSet.copyOf(appStateArray);
            }
            appName$1.elem = (String)params.getOrElse((Object)ECConstants$.MODULE$.YARN_APP_NAME_KEY(), (Function0 & Serializable & scala.Serializable)() -> "");
        }, (Function1 & Serializable & scala.Serializable)e -> {
            String msg = new StringBuilder(16).append("Invalid params. ").append(e.getMessage()).toString();
            this.logger().error(msg, e);
            throw new EngineConnException(40102, msg);
        });
        YarnClient yarnClient = YarnUtil$.MODULE$.getYarnClient();
        List appList = yarnClient.getApplications(applicationTypeSet, (EnumSet)appStateSet.elem);
        scala.collection.mutable.HashMap rsMap = new scala.collection.mutable.HashMap();
        Utils$.MODULE$.tryCatch((Function0 & Serializable & scala.Serializable)() -> {
            String appTypeStr = this.json().writeValueAsString((Object)applicationTypeSet);
            String appStateStr = this.json().writeValueAsString((Object)((EnumSet)appStateSet$1.elem));
            ArrayList rsAppList = new ArrayList();
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(appList).asScala()).foreach((Function1 & Serializable & scala.Serializable)report -> {
                if (report.getName().contains((String)appName$1.elem)) {
                    HashMap<String, String> tmpMap = new HashMap<String, String>();
                    tmpMap.put(ECConstants$.MODULE$.YARN_APP_NAME_KEY(), report.getName());
                    tmpMap.put(ECConstants$.MODULE$.YARN_APP_TYPE_KEY(), report.getApplicationType());
                    tmpMap.put(ECConstants$.MODULE$.YARN_APPID_NAME_KEY(), report.getApplicationId().toString());
                    tmpMap.put(ECConstants$.MODULE$.YARN_APP_URL_KEY(), report.getTrackingUrl());
                    FinalApplicationStatus finalApplicationStatus = report.getFinalApplicationStatus();
                    FinalApplicationStatus finalApplicationStatus2 = FinalApplicationStatus.UNDEFINED;
                    YarnApplicationState appStatus = (finalApplicationStatus == null ? finalApplicationStatus2 != null : !finalApplicationStatus.equals(finalApplicationStatus2)) ? report.getFinalApplicationStatus() : report.getYarnApplicationState();
                    tmpMap.put(ECConstants$.MODULE$.NODE_STATUS_KEY(), YarnUtil$.MODULE$.convertYarnStateToNodeStatus(report.getApplicationId().toString(), appStatus.toString()).toString());
                    return BoxesRunTime.boxToBoolean((boolean)rsAppList.add(tmpMap));
                }
                return BoxedUnit.UNIT;
            });
            String listStr = this.json().writeValueAsString(rsAppList);
            this.logger().info(new StringBuilder(63).append("List yarn apps, params : appTypeSet : ").append(appTypeStr).append(", appStateSet : ").append(appStateStr).append(", list : ").append(listStr).toString());
            return rsMap.$plus$eq(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)ECConstants$.MODULE$.YARN_APP_RESULT_LIST_KEY()), (Object)listStr));
        }, (Function1 & Serializable & scala.Serializable)x0$1 -> {
            Throwable throwable = x0$1;
            if (throwable instanceof Exception) {
                Exception exception = (Exception)throwable;
                String msg = new StringBuilder(34).append("convert listStr failed. Because : ").append(exception.getMessage()).toString();
                this.logger().error(msg);
                throw exception;
            }
            throw new MatchError((Object)throwable);
        });
        return rsMap.toMap(Predef$.MODULE$.$conforms());
    }

    public ListOperator() {
        Operator.$init$((Operator)this);
        Logging.$init$((Logging)this);
        this.json = BDPJettyServerHelper$.MODULE$.jacksonJson();
    }
}

