/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.parser;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.config.Lex;
import org.apache.calcite.sql.SqlDrop;
import org.apache.calcite.sql.SqlExplain;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlNodeList;
import org.apache.calcite.sql.SqlSetOption;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.validate.SqlConformance;
import org.apache.flink.sql.parser.ddl.SqlAlterDatabase;
import org.apache.flink.sql.parser.ddl.SqlAlterTable;
import org.apache.flink.sql.parser.ddl.SqlCreateCatalog;
import org.apache.flink.sql.parser.ddl.SqlCreateDatabase;
import org.apache.flink.sql.parser.ddl.SqlCreateFunction;
import org.apache.flink.sql.parser.ddl.SqlCreateTable;
import org.apache.flink.sql.parser.ddl.SqlCreateView;
import org.apache.flink.sql.parser.ddl.SqlDropCatalog;
import org.apache.flink.sql.parser.ddl.SqlDropDatabase;
import org.apache.flink.sql.parser.ddl.SqlDropTable;
import org.apache.flink.sql.parser.ddl.SqlDropView;
import org.apache.flink.sql.parser.ddl.SqlUseCatalog;
import org.apache.flink.sql.parser.ddl.SqlUseDatabase;
import org.apache.flink.sql.parser.dml.RichSqlInsert;
import org.apache.flink.sql.parser.dql.SqlRichDescribeTable;
import org.apache.flink.sql.parser.dql.SqlShowCatalogs;
import org.apache.flink.sql.parser.dql.SqlShowDatabases;
import org.apache.flink.sql.parser.dql.SqlShowFunctions;
import org.apache.flink.sql.parser.dql.SqlShowTables;
import org.apache.flink.sql.parser.impl.FlinkSqlParserImpl;
import org.apache.flink.sql.parser.validate.FlinkSqlConformance;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlParseException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationFactory;
import org.apache.linkis.engineconnplugin.flink.client.sql.parser.SqlCommand;
import org.apache.linkis.engineconnplugin.flink.client.sql.parser.SqlCommandCall;
import org.apache.linkis.engineconnplugin.flink.client.sql.parser.SqlCommandParser;
import org.apache.linkis.engineconnplugin.flink.util.ClassUtil;

public class SqlCommandParserImpl
implements SqlCommandParser {
    private static SqlCommandParser sqlCommandParser;

    @Override
    public Optional<SqlCommandCall> parse(String stmt, boolean isBlinkPlanner) throws SqlParseException {
        String stmtForRegexMatch = stmt.trim();
        if (stmtForRegexMatch.endsWith(";")) {
            stmtForRegexMatch = stmtForRegexMatch.substring(0, stmtForRegexMatch.length() - 1).trim();
        }
        for (SqlCommand cmd : SqlCommand.values()) {
            Matcher matcher;
            if (!cmd.hasPattern() || !(matcher = cmd.getPattern().matcher(stmtForRegexMatch)).matches()) continue;
            String[] groups = new String[matcher.groupCount()];
            for (int i = 0; i < groups.length; ++i) {
                groups[i] = matcher.group(i + 1);
            }
            return cmd.getOperandConverter().apply(groups).map(operands -> new SqlCommandCall(cmd, (String[])operands));
        }
        return this.parseStmt(stmt, isBlinkPlanner);
    }

    private Optional<SqlCommandCall> parseStmt(String stmt, boolean isBlinkPlanner) throws SqlParseException {
        String[] operands;
        SqlCommand cmd;
        SqlNodeList sqlNodes;
        SqlParser.Config config = this.createSqlParserConfig(isBlinkPlanner);
        SqlParser sqlParser = SqlParser.create((String)stmt, (SqlParser.Config)config);
        try {
            sqlNodes = sqlParser.parseStmtList();
        }
        catch (org.apache.calcite.sql.parser.SqlParseException e) {
            throw new SqlParseException(FlinkErrorCodeSummary.FAILED_PARSE_STATEMENT.getErrorDesc(), (Throwable)e);
        }
        if (sqlNodes.size() != 1) {
            throw new SqlParseException(FlinkErrorCodeSummary.ONLY_SINGLE_STATEMENT.getErrorDesc());
        }
        SqlNode node = sqlNodes.get(0);
        if (node.getKind().belongsTo((Collection)SqlKind.QUERY)) {
            cmd = SqlCommand.SELECT;
            operands = new String[]{stmt};
        } else if (node instanceof RichSqlInsert) {
            RichSqlInsert insertNode = (RichSqlInsert)node;
            cmd = insertNode.isOverwrite() ? SqlCommand.INSERT_OVERWRITE : SqlCommand.INSERT_INTO;
            operands = new String[]{stmt, insertNode.getTargetTable().toString()};
        } else if (node instanceof SqlShowTables) {
            cmd = SqlCommand.SHOW_TABLES;
            operands = new String[]{};
        } else if (node instanceof SqlCreateTable) {
            cmd = SqlCommand.CREATE_TABLE;
            operands = new String[]{stmt};
        } else if (node instanceof SqlDropTable) {
            cmd = SqlCommand.DROP_TABLE;
            operands = new String[]{stmt};
        } else if (node instanceof SqlCreateCatalog) {
            cmd = SqlCommand.CREATE_CATALOG;
            operands = new String[]{stmt};
        } else if (node instanceof SqlDropCatalog) {
            cmd = SqlCommand.DROP_CATALOG;
            operands = new String[]{stmt};
        } else if (node instanceof SqlAlterTable) {
            cmd = SqlCommand.ALTER_TABLE;
            operands = new String[]{stmt};
        } else if (node instanceof SqlCreateView) {
            SqlCreateView createViewNode = (SqlCreateView)node;
            cmd = SqlCommand.CREATE_VIEW;
            operands = new String[]{createViewNode.getViewName().toString(), createViewNode.getQuery().toString()};
        } else if (node instanceof SqlDropView) {
            boolean ifExists;
            Field ifExistsField;
            SqlDropView dropViewNode = (SqlDropView)node;
            try {
                ifExistsField = SqlDrop.class.getDeclaredField("ifExists");
            }
            catch (NoSuchFieldException e) {
                throw new SqlParseException(FlinkErrorCodeSummary.FAILED_DROP_STATEMENT.getErrorDesc(), (Throwable)e);
            }
            ifExistsField.setAccessible(true);
            try {
                ifExists = ifExistsField.getBoolean(dropViewNode);
            }
            catch (IllegalAccessException e) {
                throw new SqlParseException(FlinkErrorCodeSummary.FAILED_DROP_STATEMENT.getErrorDesc(), (Throwable)e);
            }
            cmd = SqlCommand.DROP_VIEW;
            operands = new String[]{dropViewNode.getViewName().toString(), String.valueOf(ifExists)};
        } else if (node instanceof SqlShowDatabases) {
            cmd = SqlCommand.SHOW_DATABASES;
            operands = new String[]{};
        } else if (node instanceof SqlCreateDatabase) {
            cmd = SqlCommand.CREATE_DATABASE;
            operands = new String[]{stmt};
        } else if (node instanceof SqlCreateFunction) {
            cmd = SqlCommand.CREATE_FUNCTION;
            operands = new String[]{stmt};
        } else if (node instanceof SqlDropDatabase) {
            cmd = SqlCommand.DROP_DATABASE;
            operands = new String[]{stmt};
        } else if (node instanceof SqlAlterDatabase) {
            cmd = SqlCommand.ALTER_DATABASE;
            operands = new String[]{stmt};
        } else if (node instanceof SqlShowCatalogs) {
            cmd = SqlCommand.SHOW_CATALOGS;
            operands = new String[]{};
        } else if (node instanceof SqlShowFunctions) {
            cmd = SqlCommand.SHOW_FUNCTIONS;
            operands = new String[]{};
        } else if (node instanceof SqlUseCatalog) {
            cmd = SqlCommand.USE_CATALOG;
            operands = new String[]{((SqlUseCatalog)node).getCatalogName().getSimple()};
        } else if (node instanceof SqlUseDatabase) {
            cmd = SqlCommand.USE;
            operands = new String[]{((SqlUseDatabase)node).getDatabaseName().toString()};
        } else if (node instanceof SqlRichDescribeTable) {
            cmd = SqlCommand.DESCRIBE_TABLE;
            String[] fullTableName = ((SqlRichDescribeTable)node).fullTableName();
            String escapedName = Stream.of(fullTableName).map(s -> "`" + s + "`").collect(Collectors.joining("."));
            operands = new String[]{escapedName};
        } else if (node instanceof SqlExplain) {
            cmd = SqlCommand.EXPLAIN;
            operands = new String[]{((SqlExplain)node).getExplicandum().toString()};
        } else if (node instanceof SqlSetOption) {
            SqlSetOption setNode = (SqlSetOption)node;
            if (setNode.getValue() != null) {
                cmd = SqlCommand.SET;
                operands = new String[]{setNode.getName().toString(), setNode.getValue().toString()};
            } else {
                cmd = SqlCommand.RESET;
                operands = "ALL".equals(setNode.getName().toString().toUpperCase()) ? new String[]{} : new String[]{setNode.getName().toString()};
            }
        } else {
            cmd = null;
            operands = new String[]{};
        }
        if (cmd == null) {
            return Optional.empty();
        }
        return Optional.of(new SqlCommandCall(cmd, operands));
    }

    private SqlParser.Config createSqlParserConfig(boolean isBlinkPlanner) {
        SqlParser.Config config = SqlParser.config().withParserFactory(FlinkSqlParserImpl.FACTORY).withConformance((SqlConformance)FlinkSqlConformance.DEFAULT).withLex(Lex.JAVA);
        if (isBlinkPlanner) {
            return config.withIdentifierMaxLength(256);
        }
        return config;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SqlCommandParser getInstance() {
        if (sqlCommandParser != null) return sqlCommandParser;
        Class<OperationFactory> clazz = OperationFactory.class;
        synchronized (OperationFactory.class) {
            if (sqlCommandParser != null) return sqlCommandParser;
            sqlCommandParser = ClassUtil.getInstance(SqlCommandParser.class, new SqlCommandParserImpl());
            // ** MonitorExit[var0] (shouldn't be in output)
            return sqlCommandParser;
        }
    }
}

