/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.result;

import java.io.IOException;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParseException;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonParser;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.core.JsonToken;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.DeserializationContext;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.JsonNode;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.deser.std.StdDeserializer;
import org.apache.flink.table.types.logical.DateType;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.RowType;
import org.apache.flink.table.types.logical.TimeType;
import org.apache.flink.table.types.logical.TimestampType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;

public class ResultSetJsonDeserializer
extends StdDeserializer<ResultSet> {
    protected ResultSetJsonDeserializer() {
        super(ResultSet.class);
    }

    public ResultSet deserialize(JsonParser jsonParser, DeserializationContext ctx) throws IOException {
        JsonNode dataNode;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        List<Object> changeFlags = null;
        JsonNode resultKindNode = node.get("result_kind");
        if (resultKindNode == null) {
            throw new JsonParseException(jsonParser, "Field resultKind must be provided");
        }
        JsonParser resultKindParser = node.get("result_kind").traverse();
        resultKindParser.nextToken();
        ResultKind resultKind = (ResultKind)((Object)ctx.readValue(resultKindParser, ResultKind.class));
        JsonNode columnNode = node.get("columns");
        if (columnNode == null) {
            throw new JsonParseException(jsonParser, "Field column must be provided");
        }
        JsonParser columnParser = node.get("columns").traverse();
        columnParser.nextToken();
        List<Object> columns = Arrays.asList((Object[])ctx.readValue(columnParser, ColumnInfo[].class));
        JsonNode changeFlagNode = node.get("change_flags");
        if (changeFlagNode != null) {
            JsonParser changeFlagParser = changeFlagNode.traverse();
            changeFlagParser.nextToken();
            changeFlags = Arrays.asList((Object[])ctx.readValue(changeFlagParser, Boolean[].class));
        }
        if ((dataNode = node.get("data")) == null) {
            throw new JsonParseException(jsonParser, "Field data must be provided");
        }
        List<Row> data = this.deserializeRows(columns, dataNode, ctx);
        return ResultSet.builder().resultKind(resultKind).columns(columns).data(data).changeFlags(changeFlags).build();
    }

    private List<Row> deserializeRows(List<ColumnInfo> columns, JsonNode dataNode, DeserializationContext ctx) throws IOException {
        if (!dataNode.isArray()) {
            throw new JsonParseException(dataNode.traverse(), "Expecting data to be an array but it's not");
        }
        ArrayList<RowType.RowField> fields = new ArrayList<RowType.RowField>();
        for (ColumnInfo column : columns) {
            fields.add(new RowType.RowField(column.getName(), column.getLogicalType()));
        }
        RowType rowType = new RowType(fields);
        ArrayList<Row> data = new ArrayList<Row>();
        for (JsonNode rowNode : dataNode) {
            data.add(this.deserializeRow(rowType, rowNode, ctx));
        }
        return data;
    }

    private LocalDate deserializeLocalDate(JsonParser parser, DeserializationContext ctx) throws IOException {
        return LocalDate.parse((CharSequence)ctx.readValue(parser, String.class));
    }

    private LocalTime deserializeLocalTime(JsonParser parser, DeserializationContext ctx) throws IOException {
        return LocalTime.parse((CharSequence)ctx.readValue(parser, String.class));
    }

    private LocalDateTime deserializeLocalDateTime(JsonParser parser, DeserializationContext ctx) throws IOException {
        return LocalDateTime.parse((CharSequence)ctx.readValue(parser, String.class));
    }

    private Row deserializeRow(RowType type, JsonNode node, DeserializationContext ctx) throws IOException {
        if (!node.isArray()) {
            throw new JsonParseException(node.traverse(), "Expecting row to be an array but it's not");
        }
        int fieldCount = type.getFieldCount();
        List fields = type.getFields();
        Row row = new Row(fieldCount);
        int i = 0;
        for (JsonNode fieldNode : node) {
            if (i >= fieldCount) {
                throw new JsonParseException(node.traverse(), "Number of columns in the row is not consistent with column infos");
            }
            row.setField(i, this.deserializeObject(((RowType.RowField)fields.get(i)).getType(), fieldNode, ctx));
            ++i;
        }
        if (i != fieldCount) {
            throw new JsonParseException(node.traverse(), "Number of columns in the row is not consistent with column infos");
        }
        return row;
    }

    private Object deserializeObject(LogicalType type, JsonNode node, DeserializationContext ctx) throws IOException {
        if (type instanceof RowType) {
            return this.deserializeRow((RowType)type, node, ctx);
        }
        JsonParser parser = node.traverse();
        parser.nextToken();
        if (parser.currentToken() == JsonToken.VALUE_NULL) {
            return null;
        }
        if (type instanceof DateType) {
            return this.deserializeLocalDate(parser, ctx);
        }
        if (type instanceof TimeType) {
            return this.deserializeLocalTime(parser, ctx);
        }
        if (type instanceof TimestampType) {
            return this.deserializeLocalDateTime(parser, ctx);
        }
        return ctx.readValue(parser, type.getDefaultConversion());
    }
}

