/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.result;

import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.databind.annotation.JsonSerialize;
import org.apache.flink.types.Row;
import org.apache.flink.util.Preconditions;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSetJsonDeserializer;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSetJsonSerializer;

@JsonSerialize(using=ResultSetJsonSerializer.class)
@JsonDeserialize(using=ResultSetJsonDeserializer.class)
public class ResultSet {
    static final String FIELD_NAME_RESULT_KIND = "result_kind";
    static final String FIELD_NAME_COLUMNS = "columns";
    static final String FIELD_NAME_DATA = "data";
    static final String FIELD_NAME_CHANGE_FLAGS = "change_flags";
    private final ResultKind resultKind;
    private final List<ColumnInfo> columns;
    private final List<Row> data;
    private final List<Boolean> changeFlags;

    private ResultSet(ResultKind resultKind, List<ColumnInfo> columns, List<Row> data, @Nullable List<Boolean> changeFlags) {
        this.resultKind = (ResultKind)((Object)Preconditions.checkNotNull((Object)((Object)resultKind), (String)"resultKind must not be null"));
        this.columns = (List)Preconditions.checkNotNull(columns, (String)"columns must not be null");
        this.data = (List)Preconditions.checkNotNull(data, (String)"data must not be null");
        if (!data.isEmpty()) {
            Preconditions.checkArgument((columns.size() == data.get(0).getArity() ? 1 : 0) != 0, (Object)"the size of columns and the number of fields in the row should be equal");
        }
        this.changeFlags = changeFlags;
        if (changeFlags != null) {
            Preconditions.checkArgument((data.size() == changeFlags.size() ? 1 : 0) != 0, (Object)"the size of data and the size of changeFlags should be equal");
        }
    }

    public ResultKind getResultKind() {
        return this.resultKind;
    }

    public List<ColumnInfo> getColumns() {
        return this.columns;
    }

    public List<Row> getData() {
        return this.data;
    }

    public Optional<List<Boolean>> getChangeFlags() {
        return Optional.ofNullable(this.changeFlags);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ResultSet resultSet = (ResultSet)o;
        return this.resultKind.equals((Object)resultSet.resultKind) && this.columns.equals(resultSet.columns) && this.data.equals(resultSet.data) && Objects.equals(this.changeFlags, resultSet.changeFlags);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.resultKind, this.columns, this.data, this.changeFlags});
    }

    public String toString() {
        return "ResultSet{resultKind=" + (Object)((Object)this.resultKind) + ", columns=" + this.columns + ", data=" + this.data + ", changeFlags=" + this.changeFlags + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private ResultKind resultKind = null;
        private List<ColumnInfo> columns = null;
        private List<Row> data = null;
        private List<Boolean> changeFlags = null;

        private Builder() {
        }

        public Builder resultKind(ResultKind resultKind) {
            this.resultKind = resultKind;
            return this;
        }

        public Builder columns(ColumnInfo ... columns) {
            this.columns = Arrays.asList(columns);
            return this;
        }

        public Builder columns(List<ColumnInfo> columns) {
            this.columns = columns;
            return this;
        }

        public Builder data(List<Row> data) {
            this.data = data;
            return this;
        }

        public Builder data(Row ... data) {
            this.data = Arrays.asList(data);
            return this;
        }

        public Builder changeFlags(List<Boolean> changeFlags) {
            this.changeFlags = changeFlags;
            return this;
        }

        public ResultSet build() {
            return new ResultSet(this.resultKind, this.columns, this.data, this.changeFlags);
        }
    }
}

