/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.result;

import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonCreator;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonIgnore;
import org.apache.flink.shaded.jackson2.com.fasterxml.jackson.annotation.JsonProperty;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.utils.LogicalTypeParser;
import org.apache.flink.util.Preconditions;

public class ColumnInfo {
    private static final String FIELD_NAME_NAME = "name";
    private static final String FIELD_NAME_TYPE = "type";
    @JsonProperty(value="name")
    private String name;
    @JsonProperty(value="type")
    private String type;
    @JsonIgnore
    @Nullable
    private LogicalType logicalType;

    @JsonCreator
    public ColumnInfo(@JsonProperty(value="name") String name, @JsonProperty(value="type") String type) {
        this.name = (String)Preconditions.checkNotNull((Object)name, (String)"name must not be null");
        this.type = (String)Preconditions.checkNotNull((Object)type, (String)"type must not be null");
    }

    public static ColumnInfo create(String name, LogicalType type) {
        return new ColumnInfo(name, type.toString());
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return this.type;
    }

    @JsonIgnore
    public LogicalType getLogicalType() {
        if (this.logicalType == null) {
            this.logicalType = LogicalTypeParser.parse((String)this.type);
        }
        return this.logicalType;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ColumnInfo that = (ColumnInfo)o;
        return this.name.equals(that.name) && this.type.equals(that.type);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.type);
    }

    public String toString() {
        return "ColumnInfo{name='" + this.name + '\'' + ", type='" + this.type + '\'' + '}';
    }
}

