/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import java.util.ArrayList;
import java.util.Map;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.config.entries.ViewEntry;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class ShowViewsOperation
implements NonJobOperation {
    private final ExecutionContext context;

    public ShowViewsOperation(FlinkEngineConnContext context) {
        this.context = context.getExecutionContext();
    }

    @Override
    public ResultSet execute() {
        ArrayList<Row> rows = new ArrayList<Row>();
        int maxNameLength = 1;
        for (Map.Entry entry : this.context.getEnvironment().getTables().entrySet()) {
            if (!(entry.getValue() instanceof ViewEntry)) continue;
            String name = (String)entry.getKey();
            rows.add(Row.of((Object[])new Object[]{name}));
            maxNameLength = Math.max(maxNameLength, name.length());
        }
        return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create("views", (LogicalType)new VarCharType(false, maxNameLength))).data(rows).build();
    }
}

