/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import java.util.ArrayList;
import java.util.Arrays;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class ShowTablesOperation
implements NonJobOperation {
    private final ExecutionContext context;

    public ShowTablesOperation(FlinkEngineConnContext context) {
        this.context = context.getExecutionContext();
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        ArrayList<Row> rows = new ArrayList<Row>();
        int maxNameLength = 1;
        TableEnvironment tableEnv = this.context.getTableEnvironment();
        for (String table : this.context.wrapClassLoader(() -> Arrays.asList(tableEnv.listTables()))) {
            rows.add(Row.of((Object[])new Object[]{table}));
            maxNameLength = Math.max(maxNameLength, table.length());
        }
        return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create("tables", (LogicalType)new VarCharType(false, maxNameLength))).data(rows).build();
    }
}

