/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import org.apache.flink.table.api.ExplainDetail;
import org.apache.flink.table.api.Table;
import org.apache.flink.table.api.TableEnvironment;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class ExplainOperation
implements NonJobOperation {
    private final ExecutionContext context;
    private final String statement;

    public ExplainOperation(FlinkEngineConnContext context, String statement) {
        this.context = context.getExecutionContext();
        this.statement = statement;
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        TableEnvironment tableEnv = this.context.getTableEnvironment();
        try {
            String explanation = this.context.wrapClassLoader(() -> tableEnv.explainSql(this.statement, new ExplainDetail[0]));
            return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create("explanation", (LogicalType)new VarCharType(false, explanation.length()))).data(Row.of((Object[])new Object[]{explanation})).build();
        }
        catch (SqlExecutionException t) {
            throw t;
        }
        catch (Exception t) {
            throw new SqlExecutionException(FlinkErrorCodeSummary.INVALID_SQL_STATEMENT.getErrorDesc(), (Throwable)t);
        }
    }

    private Table createTable(ExecutionContext context, TableEnvironment tableEnv, String selectQuery) throws SqlExecutionException {
        try {
            return context.wrapClassLoader(() -> tableEnv.sqlQuery(selectQuery));
        }
        catch (Exception t) {
            throw new SqlExecutionException(FlinkErrorCodeSummary.INVALID_SQL_STATEMENT.getErrorDesc(), (Throwable)t);
        }
    }
}

