/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation.impl;

import org.apache.flink.table.api.TableEnvironment;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.NonJobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.OperationUtil;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.client.sql.parser.SqlCommand;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;

public class DDLOperation
implements NonJobOperation {
    private final ExecutionContext context;
    private final String ddl;
    private final SqlCommand command;

    public DDLOperation(FlinkEngineConnContext context, String ddl, SqlCommand command) {
        this.context = context.getExecutionContext();
        this.ddl = ddl;
        this.command = command;
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        TableEnvironment tEnv = this.context.getTableEnvironment();
        try {
            this.context.wrapClassLoader(() -> tEnv.executeSql(this.ddl));
        }
        catch (Exception t) {
            throw new SqlExecutionException(this.getExceptionMsg(), (Throwable)t);
        }
        return OperationUtil.OK;
    }

    private String getExceptionMsg() {
        String actionMsg;
        switch (this.command) {
            case CREATE_TABLE: {
                actionMsg = "create a table";
                break;
            }
            case CREATE_FUNCTION: {
                actionMsg = "create a function";
                break;
            }
            case CREATE_DATABASE: {
                actionMsg = "create a database";
                break;
            }
            case DROP_TABLE: {
                actionMsg = "drop a table";
                break;
            }
            case DROP_DATABASE: {
                actionMsg = "drop a database";
                break;
            }
            case CREATE_CATALOG: {
                actionMsg = "create a catalog";
                break;
            }
            case DROP_CATALOG: {
                actionMsg = "drop a catalog";
                break;
            }
            case ALTER_TABLE: {
                actionMsg = "alter a table";
                break;
            }
            case ALTER_DATABASE: {
                actionMsg = "alter a database";
                break;
            }
            default: {
                actionMsg = null;
            }
        }
        if (actionMsg != null) {
            return String.format("Could not %s from statement: %s.", actionMsg, this.ddl);
        }
        return "Invalid DDL statement.";
    }
}

