/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.sql.operation;

import java.util.List;
import java.util.Optional;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobStatus;
import org.apache.flink.api.java.tuple.Tuple2;
import org.apache.flink.table.types.logical.LogicalType;
import org.apache.flink.table.types.logical.VarCharType;
import org.apache.flink.types.Row;
import org.apache.linkis.engineconnplugin.flink.client.deployment.AbstractSessionClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.shims.errorcode.FlinkErrorCodeSummary;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.JobExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.SqlExecutionException;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.JobOperation;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ColumnInfo;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultKind;
import org.apache.linkis.engineconnplugin.flink.client.sql.operation.result.ResultSet;
import org.apache.linkis.engineconnplugin.flink.context.FlinkEngineConnContext;
import org.apache.linkis.engineconnplugin.flink.listener.FlinkListenerGroupImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractJobOperation
extends FlinkListenerGroupImpl
implements JobOperation {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractJobOperation.class);
    protected final FlinkEngineConnContext context;
    private AbstractSessionClusterDescriptorAdapter clusterDescriptorAdapter;
    private volatile JobID jobId;
    protected boolean noMoreResult;
    private volatile boolean isJobCanceled;
    protected final Object lock = new Object();

    public AbstractJobOperation(FlinkEngineConnContext context) {
        this.context = context;
        this.isJobCanceled = false;
        this.noMoreResult = false;
    }

    @Override
    public void setClusterDescriptorAdapter(AbstractSessionClusterDescriptorAdapter clusterDescriptor) {
        this.clusterDescriptorAdapter = clusterDescriptor;
    }

    @Override
    public ResultSet execute() throws SqlExecutionException {
        this.jobId = this.submitJob();
        this.clusterDescriptorAdapter.setJobId(this.jobId);
        String strJobId = this.jobId.toString();
        return ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(ColumnInfo.create("jobId", (LogicalType)new VarCharType(false, strJobId.length()))).data(Row.of((Object[])new Object[]{strJobId})).build();
    }

    public JobID transformToJobInfo(ResultSet resultSet) throws SqlExecutionException {
        if (resultSet.getColumns().size() != 1) {
            throw new SqlExecutionException(FlinkErrorCodeSummary.NOT_SUPPORT_TRANSFORM.getErrorDesc());
        }
        Row row = resultSet.getData().get(0);
        return JobID.fromHexString((String)row.getField(0).toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public JobStatus getJobStatus() throws JobExecutionException {
        Object object = this.lock;
        synchronized (object) {
            return this.clusterDescriptorAdapter.getJobStatus();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void cancelJob() throws JobExecutionException {
        if (this.isJobCanceled) {
            return;
        }
        Object object = this.lock;
        synchronized (object) {
            if (this.jobId == null) {
                LOG.error("No job has been submitted. This is a bug.");
                throw new IllegalStateException("No job has been submitted. This is a bug.");
            }
            if (this.isJobCanceled) {
                return;
            }
            this.cancelJobInternal();
            this.isJobCanceled = true;
        }
    }

    protected abstract JobID submitJob() throws SqlExecutionException;

    protected void cancelJobInternal() throws JobExecutionException {
        LOG.info("Start to cancel job {} and result retrieval.", (Object)this.getJobId());
        if (this.noMoreResult) {
            return;
        }
        this.clusterDescriptorAdapter.cancelJob();
    }

    @Override
    public JobID getJobId() {
        if (this.jobId == null) {
            throw new IllegalStateException("No job has been submitted. This is a bug.");
        }
        return this.jobId;
    }

    @Override
    public synchronized Optional<ResultSet> getJobResult() throws SqlExecutionException {
        Optional<Tuple2<List<Row>, List<Boolean>>> newResults = this.fetchJobResults();
        return newResults.map(r -> ResultSet.builder().resultKind(ResultKind.SUCCESS_WITH_CONTENT).columns(this.getColumnInfos()).data((List)r.f0).changeFlags((List)((Tuple2)newResults.get()).f1).build());
    }

    protected abstract Optional<Tuple2<List<Row>, List<Boolean>>> fetchJobResults() throws SqlExecutionException;

    protected abstract List<ColumnInfo> getColumnInfos();
}

