/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.engineconnplugin.flink.client.deployment;

import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.flink.api.common.JobID;
import org.apache.flink.client.deployment.ClusterSpecification;
import org.apache.flink.client.program.ClusterClientProvider;
import org.apache.flink.yarn.YarnClusterDescriptor;
import org.apache.hadoop.yarn.api.records.ApplicationId;
import org.apache.linkis.engineconnplugin.flink.client.context.ExecutionContext;
import org.apache.linkis.engineconnplugin.flink.client.deployment.AbstractSessionClusterDescriptorAdapter;
import org.apache.linkis.engineconnplugin.flink.client.shims.exception.JobExecutionException;

public class YarnSessionClusterDescriptorAdapter
extends AbstractSessionClusterDescriptorAdapter {
    public YarnSessionClusterDescriptorAdapter(ExecutionContext executionContext) {
        super(executionContext);
    }

    @Override
    public boolean isGloballyTerminalState() throws JobExecutionException {
        return super.isGloballyTerminalStateByYarn();
    }

    @Override
    public void deployCluster() throws JobExecutionException {
        try {
            ClusterSpecification clusterSpecification = this.executionContext.getClusterClientFactory().getClusterSpecification(this.executionContext.getFlinkConfig());
            YarnClusterDescriptor clusterDescriptor = this.executionContext.createClusterDescriptor();
            ClusterClientProvider clusterClientProvider = clusterDescriptor.deploySessionCluster(clusterSpecification);
            this.clusterClient = clusterClientProvider.getClusterClient();
            this.clusterID = (ApplicationId)this.clusterClient.getClusterId();
            this.webInterfaceUrl = this.clusterClient.getWebInterfaceURL();
            this.bindApplicationId();
        }
        catch (Exception e) {
            throw new JobExecutionException(ExceptionUtils.getRootCauseMessage((Throwable)e), (Throwable)e);
        }
    }

    @Override
    public void setJobId(JobID jobId) {
        super.setJobId(jobId);
    }
}

