/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.ecm.restful;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileOwnerAttributeView;
import java.nio.file.attribute.UserPrincipal;
import java.text.MessageFormat;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Consts;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.ecm.errorcode.EngineconnServerErrorCodeSummary;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"ECM"})
@RequestMapping(path={"/engineconnManager"})
@RestController
public class ECMRestfulApi {
    private final Logger logger = LoggerFactory.getLogger(ECMRestfulApi.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(value="downloadEngineLog", notes="download engine log", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="emInstance", required=true, dataType="String", example="xxx0002:9102"), @ApiImplicitParam(name="instance", required=true, dataType="String", example="xxx0002:35873"), @ApiImplicitParam(name="logDirSuffix", required=true, dataType="String"), @ApiImplicitParam(name="logType", required=true, dataType="String")})
    @ApiOperationSupport(ignoreParameters={"json"})
    @RequestMapping(path={"/downloadEngineLog"}, method={RequestMethod.GET})
    public Message downloadEngineLog(HttpServletRequest req, HttpServletResponse response, @RequestParam(value="emInstance") String emInstance, @RequestParam(value="instance") String instance, @RequestParam(value="logDirSuffix") String logDirSuffix, @RequestParam(value="logType") String logType) throws IOException {
        BufferedInputStream fis;
        FileInputStream inputStream;
        ServletOutputStream outputStream;
        block13: {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"downloadEngineLog");
            if (StringUtils.isBlank((CharSequence)instance)) {
                return Message.error((String)MessageFormat.format(EngineconnServerErrorCodeSummary.PARAMETER_NOT_NULL.getErrorDesc(), "instance"));
            }
            if (StringUtils.isBlank((CharSequence)logDirSuffix)) {
                return Message.error((String)MessageFormat.format(EngineconnServerErrorCodeSummary.PARAMETER_NOT_NULL.getErrorDesc(), "logDirSuffix"));
            }
            if (StringUtils.isBlank((CharSequence)logType)) {
                return Message.error((String)MessageFormat.format(EngineconnServerErrorCodeSummary.PARAMETER_NOT_NULL.getErrorDesc(), "logType"));
            }
            if (!(logType.equals("stdout") || logType.equals("stderr") || logType.equals("gc") || logType.equals("yarnApp"))) {
                return Message.error((String)EngineconnServerErrorCodeSummary.LOGTYPE_ERROR.getErrorDesc());
            }
            FileOwnerAttributeView ownerView = Files.getFileAttributeView(Paths.get(logDirSuffix + "/" + logType, new String[0]), FileOwnerAttributeView.class, new LinkOption[0]);
            UserPrincipal owner = ownerView.getOwner();
            if (!owner.getName().equals(userName) && Configuration.isNotAdmin((String)userName) && Configuration.isNotJobHistoryAdmin((String)userName)) {
                return Message.error((String)MessageFormat.format(EngineconnServerErrorCodeSummary.NOT_PERMISSION.getErrorDesc(), userName, emInstance));
            }
            File inputFile = new File(logDirSuffix, logType);
            if (!inputFile.exists()) {
                return Message.error((String)MessageFormat.format(EngineconnServerErrorCodeSummary.LOG_IS_NOT_EXISTS.getErrorDesc(), logDirSuffix));
            }
            long fileSizeInBytes = inputFile.length();
            long fileSizeInMegabytes = fileSizeInBytes / 0x100000L;
            if (fileSizeInMegabytes > 100L) {
                return Message.error((String)MessageFormat.format(EngineconnServerErrorCodeSummary.FILE_IS_OVERSIZE.getErrorDesc(), logDirSuffix));
            }
            outputStream = null;
            inputStream = null;
            fis = null;
            PrintWriter writer = null;
            try {
                inputStream = new FileInputStream(inputFile);
                fis = new BufferedInputStream(inputStream);
                byte[] buffer = new byte[1024];
                int bytesRead = 0;
                response.setCharacterEncoding(Consts.UTF_8.toString());
                Path source = Paths.get(inputFile.getPath(), new String[0]);
                response.addHeader("Content-Type", Files.probeContentType(source));
                response.addHeader("Content-Disposition", "attachment;filename=" + instance.replace(":", "_") + "_" + logType + ".txt");
                response.addHeader("Content-Length", fileSizeInBytes + "");
                outputStream = response.getOutputStream();
                while ((bytesRead = fis.read(buffer, 0, 1024)) != -1) {
                    outputStream.write(buffer, 0, bytesRead);
                }
                if (outputStream == null) break block13;
            }
            catch (IOException e) {
                block14: {
                    try {
                        this.logger.error("Download EngineLog Failed Msg :", (Throwable)e);
                        response.reset();
                        response.setCharacterEncoding(Consts.UTF_8.toString());
                        response.setContentType("text/plain; charset=utf-8");
                        writer = response.getWriter();
                        writer.append("error(\u9519\u8bef):" + e.getMessage());
                        writer.flush();
                        if (outputStream == null) break block14;
                    }
                    catch (Throwable throwable) {
                        if (outputStream != null) {
                            outputStream.flush();
                        }
                        IOUtils.closeQuietly(outputStream);
                        IOUtils.closeQuietly(fis);
                        IOUtils.closeQuietly((InputStream)inputStream);
                        throw throwable;
                    }
                    outputStream.flush();
                }
                IOUtils.closeQuietly(outputStream);
                IOUtils.closeQuietly((InputStream)fis);
                IOUtils.closeQuietly((InputStream)inputStream);
            }
            outputStream.flush();
        }
        IOUtils.closeQuietly((OutputStream)outputStream);
        IOUtils.closeQuietly((InputStream)fis);
        IOUtils.closeQuietly((InputStream)inputStream);
        return Message.ok();
    }
}

