/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.validate.strategy;

import java.util.List;
import java.util.regex.Pattern;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.common.errorcode.LinkisDatasourceManagerErrorCodeSummary;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateException;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidateStrategy;

public class RegExpParameterValidateStrategy
implements ParameterValidateStrategy {
    @Override
    public boolean accept(DataSourceParamKeyDefinition.ValueType valueType) {
        return valueType == DataSourceParamKeyDefinition.ValueType.EMAIL || valueType == DataSourceParamKeyDefinition.ValueType.TEXT || valueType == DataSourceParamKeyDefinition.ValueType.LIST || valueType == DataSourceParamKeyDefinition.ValueType.TEXTAREA;
    }

    @Override
    public Object validate(DataSourceParamKeyDefinition keyDefinition, Object actualValue) throws ParameterValidateException {
        String valueRegex = keyDefinition.getValueRegex();
        if (StringUtils.isNotBlank((CharSequence)valueRegex)) {
            if (actualValue instanceof List) {
                List valueList = (List)actualValue;
                for (Object value : valueList) {
                    this.match(keyDefinition.getKey(), keyDefinition.getName(), String.valueOf(value), valueRegex);
                }
            } else {
                this.match(keyDefinition.getKey(), keyDefinition.getName(), String.valueOf(actualValue), valueRegex);
            }
        }
        return actualValue;
    }

    private void match(String key, String name, String value, String valueRegex) throws ParameterValidateException {
        boolean match = Pattern.matches(valueRegex, value);
        if (!match) {
            throw new ParameterValidateException(LinkisDatasourceManagerErrorCodeSummary.PARAM_VALIDATE_FAILED.getErrorDesc() + ", [the value: '" + String.valueOf(value) + "' to key: '" + key + "(" + name + ")' doesn't match]");
        }
    }
}

