/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.datasourcemanager.core.restful;

import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.PostConstruct;
import javax.servlet.http.HttpServletRequest;
import javax.validation.ConstraintViolationException;
import javax.validation.Validator;
import javax.validation.groups.Default;
import org.apache.linkis.common.exception.ErrorException;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceEnv;
import org.apache.linkis.datasourcemanager.common.domain.DataSourceParamKeyDefinition;
import org.apache.linkis.datasourcemanager.core.formdata.FormDataTransformerFactory;
import org.apache.linkis.datasourcemanager.core.formdata.MultiPartFormDataTransformer;
import org.apache.linkis.datasourcemanager.core.restful.RestfulApiHelper;
import org.apache.linkis.datasourcemanager.core.service.DataSourceInfoService;
import org.apache.linkis.datasourcemanager.core.service.DataSourceRelateService;
import org.apache.linkis.datasourcemanager.core.validate.ParameterValidator;
import org.apache.linkis.datasourcemanager.core.vo.DataSourceEnvVo;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"data source admin restful api"})
@RestController
@RequestMapping(value={"/data-source-manager"}, produces={"application/json"})
public class DataSourceAdminRestfulApi {
    private final List<String> permitSystemList = Arrays.asList("Qualitis");
    @Autowired
    private DataSourceInfoService dataSourceInfoService;
    @Autowired
    private DataSourceRelateService dataSourceRelateService;
    @Autowired
    private ParameterValidator parameterValidator;
    @Autowired
    private Validator beanValidator;
    private MultiPartFormDataTransformer formDataTransformer;

    @PostConstruct
    public void initRestful() {
        this.formDataTransformer = FormDataTransformerFactory.buildCustom();
    }

    @ApiOperation(value="insertJsonEnv", notes="insert json env", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"dataSourceEnv"})
    @RequestMapping(value={"/env/json"}, method={RequestMethod.POST})
    public Message insertJsonEnv(@RequestBody DataSourceEnv dataSourceEnv, HttpServletRequest req) throws ErrorException {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"insertJsonEnv");
            if (RestfulApiHelper.isNotAdminUser(userName)) {
                return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
            }
            Set result = this.beanValidator.validate((Object)dataSourceEnv, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            if (this.dataSourceInfoService.existDataSourceEnv(dataSourceEnv.getEnvName())) {
                return Message.error((String)("The data source env named: " + dataSourceEnv.getEnvName() + " has been existed [\u6570\u636e\u6e90\u73af\u5883: " + dataSourceEnv.getEnvName() + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            dataSourceEnv.setCreateUser(userName);
            this.insertDataSourceEnv(dataSourceEnv);
            return Message.ok().data("insertId", (Object)dataSourceEnv.getId());
        }, "Fail to insert data source environment[\u65b0\u589e\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    @ApiOperation(value="insertJsonEnvBatch", notes="insert batch json env", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"dataSourceEnvList", "system"})
    @RequestMapping(value={"/env/json/batch"}, method={RequestMethod.POST})
    public Message insertJsonEnvBatch(@RequestBody List<DataSourceEnv> dataSourceEnvList, @RequestParam(value="system") String system, HttpServletRequest req) throws ErrorException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"insertJsonEnvBatch");
        if (RestfulApiHelper.isNotAdminUser(userName) && !this.permitSystemList.contains(system)) {
            return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        for (DataSourceEnv dataSourceEnv : dataSourceEnvList) {
            Set result = this.beanValidator.validate((Object)dataSourceEnv, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            if (this.dataSourceInfoService.existDataSourceEnv(dataSourceEnv.getEnvName())) {
                return Message.error((String)("The data source env named: " + dataSourceEnv.getEnvName() + " has been existed [\u6570\u636e\u6e90\u73af\u5883: " + dataSourceEnv.getEnvName() + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            dataSourceEnv.setCreateUser(userName);
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSourceEnv.getDataSourceTypeId(), DataSourceParamKeyDefinition.Scope.ENV);
            dataSourceEnv.setKeyDefinitions(keyDefinitionList);
            Map connectParams = dataSourceEnv.getConnectParams();
            this.parameterValidator.validate(keyDefinitionList, connectParams);
        }
        this.dataSourceInfoService.saveBatchDataSourceEnv(dataSourceEnvList);
        return RestfulApiHelper.doAndResponse(() -> Message.ok().data("envs", (Object)dataSourceEnvList), "Fail to insert data source environment[\u65b0\u589e\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    @ApiOperation(value="updateJsonEnvBatch", notes="update batch json env", response=Message.class)
    @ApiOperationSupport(ignoreParameters={"dataSourceEnvList", "system"})
    @RequestMapping(value={"/env/json/batch"}, method={RequestMethod.PUT})
    public Message updateEnvBatch(@RequestBody List<DataSourceEnv> dataSourceEnvList, @RequestParam(value="system") String system, HttpServletRequest request) throws ErrorException {
        String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)"updateJsonEnvBatch");
        if (RestfulApiHelper.isNotAdminUser(userName) && !this.permitSystemList.contains(system)) {
            return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
        }
        for (DataSourceEnv dataSourceEnv : dataSourceEnvList) {
            if (Objects.isNull(dataSourceEnv.getId())) {
                return Message.error((String)"Fail to update data source environment[\u66f4\u65b0\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25], [Please check the id if exists']");
            }
            Set result = this.beanValidator.validate((Object)dataSourceEnv, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            Long envId = dataSourceEnv.getId();
            dataSourceEnv.setModifyUser(userName);
            dataSourceEnv.setModifyTime(Calendar.getInstance().getTime());
            DataSourceEnv storedDataSourceEnv = this.dataSourceInfoService.getDataSourceEnv(envId);
            if (null == storedDataSourceEnv) {
                return Message.error((String)("Fail to update data source environment[\u66f4\u65b0\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25], [Please check the id:'" + envId + " is correct ']"));
            }
            if (!Objects.equals(dataSourceEnv.getEnvName(), storedDataSourceEnv.getEnvName()) && this.dataSourceInfoService.existDataSourceEnv(dataSourceEnv.getEnvName())) {
                return Message.error((String)("The data source env named: " + dataSourceEnv.getEnvName() + " has been existed [\u6570\u636e\u6e90\u73af\u5883: " + dataSourceEnv.getEnvName() + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            dataSourceEnv.setCreateUser(storedDataSourceEnv.getCreateUser());
            List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSourceEnv.getDataSourceTypeId(), DataSourceParamKeyDefinition.Scope.ENV);
            dataSourceEnv.setKeyDefinitions(keyDefinitionList);
            Map connectParams = dataSourceEnv.getConnectParams();
            this.parameterValidator.validate(keyDefinitionList, connectParams);
        }
        this.dataSourceInfoService.updateBatchDataSourceEnv(dataSourceEnvList);
        return RestfulApiHelper.doAndResponse(() -> Message.ok().data("envs", (Object)dataSourceEnvList), "Fail to update data source environment[\u66f4\u65b0\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    @ApiOperation(value="getAllEnvListByDataSourceType", notes="get all env list by data source type", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="typeId", required=true, dataType="Long", value="type id")})
    @RequestMapping(value={"/env-list/all/type/{typeId}"}, method={RequestMethod.GET})
    public Message getAllEnvListByDataSourceType(@PathVariable(value="typeId") Long typeId) {
        return RestfulApiHelper.doAndResponse(() -> {
            List<DataSourceEnv> envList = this.dataSourceInfoService.listDataSourceEnvByType(typeId);
            return Message.ok().data("envList", envList);
        }, "Fail to get data source environment list[\u83b7\u53d6\u6570\u636e\u6e90\u73af\u5883\u6e05\u5355\u5931\u8d25]");
    }

    @ApiOperation(value="getEnvEntityById", notes="get env entity by id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="envId", required=true, dataType="Long", value="env id")})
    @RequestMapping(value={"/env/{envId}"}, method={RequestMethod.GET})
    public Message getEnvEntityById(@PathVariable(value="envId") Long envId) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSourceEnv dataSourceEnv = this.dataSourceInfoService.getDataSourceEnv(envId);
            return Message.ok().data("env", (Object)dataSourceEnv);
        }, "Fail to get data source environment[\u83b7\u53d6\u6570\u636e\u6e90\u73af\u5883\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="removeEnvEntity", notes="remove env entity", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="envId", required=true, dataType="Long", value="env id")})
    @RequestMapping(value={"/env/{envId}"}, method={RequestMethod.DELETE})
    public Message removeEnvEntity(@PathVariable(value="envId") Long envId, HttpServletRequest request) {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("removeEnvEntity,envId:" + envId));
            if (RestfulApiHelper.isNotAdminUser(userName)) {
                return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
            }
            Long removeId = this.dataSourceInfoService.removeDataSourceEnv(envId);
            if (removeId < 0L) {
                return Message.error((String)("Fail to remove data source environment[\u5220\u9664\u6570\u636e\u6e90\u73af\u5883\u4fe1\u606f\u5931\u8d25], [id:" + envId + "]"));
            }
            return Message.ok().data("removeId", (Object)removeId);
        }, "Fail to remove data source environment[\u5220\u9664\u6570\u636e\u6e90\u73af\u5883\u4fe1\u606f\u5931\u8d25]");
    }

    @ApiOperation(value="updateJsonEnv", notes="update json env", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="envId", required=true, dataType="Long", value="env id")})
    @ApiOperationSupport(includeParameters={"dataSourceEnv"})
    @RequestMapping(value={"/env/{envId}/json"}, method={RequestMethod.PUT})
    public Message updateJsonEnv(@RequestBody DataSourceEnv dataSourceEnv, @PathVariable(value="envId") Long envId, HttpServletRequest request) throws ErrorException {
        return RestfulApiHelper.doAndResponse(() -> {
            String userName = ModuleUserUtils.getOperationUser((HttpServletRequest)request, (String)("updateJsonEnv,envId:" + envId));
            if (RestfulApiHelper.isNotAdminUser(userName)) {
                return Message.error((String)("User '" + userName + "' is not admin user[\u975e\u7ba1\u7406\u5458\u7528\u6237]"));
            }
            Set result = this.beanValidator.validate((Object)dataSourceEnv, new Class[]{Default.class});
            if (result.size() > 0) {
                throw new ConstraintViolationException(result);
            }
            dataSourceEnv.setId(envId);
            dataSourceEnv.setModifyUser(userName);
            dataSourceEnv.setModifyTime(Calendar.getInstance().getTime());
            DataSourceEnv storedDataSourceEnv = this.dataSourceInfoService.getDataSourceEnv(envId);
            if (null == storedDataSourceEnv) {
                return Message.error((String)("Fail to update data source environment[\u66f4\u65b0\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25], [Please check the id:'" + envId + " is correct ']"));
            }
            if (!Objects.equals(dataSourceEnv.getEnvName(), storedDataSourceEnv.getEnvName()) && this.dataSourceInfoService.existDataSourceEnv(dataSourceEnv.getEnvName())) {
                return Message.error((String)("The data source env named: " + dataSourceEnv.getEnvName() + " has been existed [\u6570\u636e\u6e90\u73af\u5883: " + dataSourceEnv.getEnvName() + " \u5df2\u7ecf\u5b58\u5728]"));
            }
            dataSourceEnv.setCreateUser(storedDataSourceEnv.getCreateUser());
            this.updateDataSourceEnv(dataSourceEnv, storedDataSourceEnv);
            return Message.ok().data("updateId", (Object)envId);
        }, "Fail to update data source environment[\u66f4\u65b0\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    @ApiOperation(value="queryDataSourceEnv", notes="query data source env", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="name", required=true, dataType="Long", value="name"), @ApiImplicitParam(name="typeId", required=true, dataType="Long", value="type id"), @ApiImplicitParam(name="currentPage", required=true, dataType="Long"), @ApiImplicitParam(name="pageSize", required=true, dataType="Long", value="page size")})
    @RequestMapping(value={"/env"}, method={RequestMethod.GET})
    public Message queryDataSourceEnv(@RequestParam(value="name", required=false) String envName, @RequestParam(value="typeId", required=false) Long dataSourceTypeId, @RequestParam(value="currentPage", required=false) Integer currentPage, @RequestParam(value="pageSize", required=false) Integer pageSize) {
        return RestfulApiHelper.doAndResponse(() -> {
            DataSourceEnvVo dataSourceEnvVo = new DataSourceEnvVo(envName, dataSourceTypeId);
            dataSourceEnvVo.setCurrentPage(null != currentPage ? currentPage : 1);
            dataSourceEnvVo.setPageSize(null != pageSize ? pageSize : 10);
            List<DataSourceEnv> queryList = this.dataSourceInfoService.queryDataSourceEnvPage(dataSourceEnvVo);
            return Message.ok().data("queryList", queryList);
        }, "Fail to query page of data source environment[\u67e5\u8be2\u6570\u636e\u6e90\u73af\u5883\u5931\u8d25]");
    }

    private void insertDataSourceEnv(DataSourceEnv dataSourceEnv) throws ErrorException {
        List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(dataSourceEnv.getDataSourceTypeId(), DataSourceParamKeyDefinition.Scope.ENV);
        dataSourceEnv.setKeyDefinitions(keyDefinitionList);
        Map connectParams = dataSourceEnv.getConnectParams();
        this.parameterValidator.validate(keyDefinitionList, connectParams);
        this.dataSourceInfoService.saveDataSourceEnv(dataSourceEnv);
    }

    private void updateDataSourceEnv(DataSourceEnv updatedOne, DataSourceEnv storedOne) throws ErrorException {
        List<DataSourceParamKeyDefinition> keyDefinitionList = this.dataSourceRelateService.getKeyDefinitionsByType(updatedOne.getDataSourceTypeId(), DataSourceParamKeyDefinition.Scope.ENV);
        updatedOne.setKeyDefinitions(keyDefinitionList);
        Map connectParams = updatedOne.getConnectParams();
        this.parameterValidator.validate(keyDefinitionList, connectParams);
        this.dataSourceInfoService.updateDataSourceEnv(updatedOne, storedOne);
    }
}

