/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.restful;

import com.fasterxml.jackson.databind.JsonNode;
import com.github.xiaoymin.knife4j.annotations.ApiOperationSupport;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.IOException;
import java.text.MessageFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.common.conf.Configuration;
import org.apache.linkis.cs.common.entity.source.ContextID;
import org.apache.linkis.cs.common.exception.CSErrorException;
import org.apache.linkis.cs.common.utils.CSCommonUtils;
import org.apache.linkis.cs.errorcode.LinkisCsServerErrorCodeSummary;
import org.apache.linkis.cs.server.enumeration.ServiceType;
import org.apache.linkis.cs.server.restful.CsRestfulParent;
import org.apache.linkis.cs.server.service.ContextIDService;
import org.apache.linkis.server.Message;
import org.apache.linkis.server.utils.ModuleUserUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@Api(tags={"cs(contextservice) recording operation"})
@RestController
@RequestMapping(path={"/contextservice"})
public class ContextIDRestfulApi
implements CsRestfulParent {
    private static final Logger logger = LoggerFactory.getLogger(ContextIDRestfulApi.class);
    @Autowired
    private ContextIDService contextIDService;

    @ApiOperation(value="createContextID", notes="create context Id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextID", dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"createContextID"}, method={RequestMethod.POST})
    public Message createContextID(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, ClassNotFoundException, IOException, CSErrorException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("createContextID,contextIDType: " + contextID.getContextIDType()));
        String res = this.contextIDService.createContextID(contextID);
        return this.generateMessage(res, "contextId");
    }

    @ApiOperation(value="GetContextID", notes="Get_Context_Id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextId", required=false, dataType="String")})
    @RequestMapping(path={"getContextID"}, method={RequestMethod.GET})
    public Message getContextID(HttpServletRequest req, @RequestParam(value="contextId", required=false) String id) throws InterruptedException, CSErrorException {
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("getContextID,contextID:" + id));
        ContextID res = this.contextIDService.getContextID(id);
        return this.generateMessage(res, "contextId");
    }

    @ApiOperation(value="updateContextID", notes="update content id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextId", dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"updateContextID"}, method={RequestMethod.POST})
    public Message updateContextID(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws InterruptedException, CSErrorException, IOException, ClassNotFoundException {
        ContextID contextID = this.getContextIDFromJsonNode(jsonNode);
        if (StringUtils.isBlank((CharSequence)contextID.getContextId())) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("updateContextID,contextID:" + contextID.getContextId()));
        this.contextIDService.updateContextID(contextID);
        return this.generateMessage(null, "contextId");
    }

    @ApiOperation(value="resetContextID", notes="reset context Id", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextId", dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"resetContextID"}, method={RequestMethod.POST})
    public Message resetContextID(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException {
        if (!jsonNode.has("contextID")) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        String id = jsonNode.get("contextID").textValue();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("resetContextID,contextID:" + id));
        this.contextIDService.resetContextID(id);
        return this.generateMessage(null, "contextId");
    }

    @ApiOperation(value="removeContextID", notes="remove context ID", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="contextId", dataType="String")})
    @ApiOperationSupport(ignoreParameters={"jsonNode"})
    @RequestMapping(path={"removeContextID"}, method={RequestMethod.POST})
    public Message removeContextID(HttpServletRequest req, @RequestBody JsonNode jsonNode) throws CSErrorException {
        String id = jsonNode.get("contextID").textValue();
        if (StringUtils.isBlank((CharSequence)id)) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "ContextID"));
        }
        ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)("removeContextID,contextID:" + id));
        this.contextIDService.removeContextID(id);
        return this.generateMessage(null, "contextId");
    }

    @ApiOperation(value="searchContextIDByTime", notes="search contextId by time", response=Message.class)
    @ApiImplicitParams(value={@ApiImplicitParam(name="createTimeStart", dataType="String"), @ApiImplicitParam(name="createTimeEnd", dataType="String"), @ApiImplicitParam(name="updateTimeStart", dataType="String"), @ApiImplicitParam(name="updateTimeEnd", dataType="String"), @ApiImplicitParam(name="accessTimeStart", dataType="String"), @ApiImplicitParam(name="accessTimeEnd", dataType="String"), @ApiImplicitParam(name="pageNow", dataType="String", value="page now"), @ApiImplicitParam(name="pageSize", dataType="String", value="page size")})
    @RequestMapping(path={"searchContextIDByTime"}, method={RequestMethod.GET})
    public Message searchContextIDByTime(HttpServletRequest req, @RequestParam(value="createTimeStart", required=false) String createTimeStart, @RequestParam(value="createTimeEnd", required=false) String createTimeEnd, @RequestParam(value="updateTimeStart", required=false) String updateTimeStart, @RequestParam(value="updateTimeEnd", required=false) String updateTimeEnd, @RequestParam(value="accessTimeStart", required=false) String accessTimeStart, @RequestParam(value="accessTimeEnd", required=false) String accessTimeEnd, @RequestParam(value="pageNow", required=false) Integer paramPageNow, @RequestParam(value="pageSize", required=false) Integer paramPageSize) throws CSErrorException {
        String username = ModuleUserUtils.getOperationUser((HttpServletRequest)req, (String)"searchContextIDByTime");
        if (Configuration.isNotAdmin((String)username)) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.NO_PERMISSION.getErrorCode(), LinkisCsServerErrorCodeSummary.NO_PERMISSION.getErrorDesc());
        }
        logger.info("user: {}, searchContextIDByTime : createTimeStart : {}, createTimeEnd : {}, updateTimeStart : {}, updateTimeEnd : {}, accessTimeStart : {}, accessTimeEnd : {}, pageNow : {}, pageSize : {}.", new Object[]{username, createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd, paramPageNow, paramPageSize});
        if (null == createTimeStart && null == createTimeEnd && null == updateTimeStart && null == updateTimeEnd && null == accessTimeStart && null == accessTimeEnd) {
            throw new CSErrorException(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorCode(), MessageFormat.format(LinkisCsServerErrorCodeSummary.PARAMS_CANNOT_EMPTY.getErrorDesc(), "createTimeStart, createTimeEnd, updateTimeStart, updateTimeEnd, accessTimeStart, accessTimeEnd cannot be all null."));
        }
        int pageStart = null == paramPageNow || paramPageNow <= 0 ? 1 : paramPageNow;
        int pageSize = null == paramPageSize || paramPageSize <= 0 || paramPageSize > 5000 ? 5000 : paramPageSize;
        Date createTimeStartDate = null;
        Date createTimeEndDate = null;
        Date updateTimeStartDate = null;
        Date updateTimeEndDate = null;
        Date accessTimeStartDate = null;
        Date accessTimeEndDate = null;
        DateTimeFormatter dtf = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        if (StringUtils.isNotBlank((CharSequence)createTimeStart)) {
            createTimeStartDate = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse(createTimeStart, dtf));
        }
        if (StringUtils.isNotBlank((CharSequence)createTimeEnd)) {
            createTimeEndDate = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse(createTimeEnd, dtf));
        }
        if (StringUtils.isNotBlank((CharSequence)updateTimeStart)) {
            updateTimeStartDate = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse(updateTimeStart, dtf));
        }
        if (StringUtils.isNotBlank((CharSequence)updateTimeEnd)) {
            updateTimeEndDate = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse(updateTimeEnd, dtf));
        }
        if (StringUtils.isNotBlank((CharSequence)accessTimeStart)) {
            accessTimeStartDate = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse(accessTimeStart, dtf));
        }
        if (StringUtils.isNotBlank((CharSequence)accessTimeEnd)) {
            accessTimeEndDate = CSCommonUtils.localDatetimeToDate((LocalDateTime)LocalDateTime.parse(accessTimeEnd, dtf));
        }
        List<String> res = this.contextIDService.searchCSIDByTime(createTimeStartDate, createTimeEndDate, updateTimeStartDate, updateTimeEndDate, accessTimeStartDate, accessTimeEndDate, pageStart, pageSize);
        Message resp = this.generateMessage(res, "contextIds");
        resp.setMethod("/api/contextservice/searchContextIDByTime");
        return resp;
    }

    @Override
    public ServiceType getServiceType() {
        return ServiceType.CONTEXT_ID;
    }
}

