/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.server.parser;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.apache.linkis.cs.common.annotation.KeywordMethod;
import org.apache.linkis.cs.server.conf.ContextServerConf;
import org.apache.linkis.cs.server.parser.KeywordMethodEntity;
import org.apache.linkis.cs.server.parser.KeywordParser;
import org.reflections.ReflectionUtils;
import org.reflections.Reflections;
import org.reflections.scanners.MethodAnnotationsScanner;
import org.reflections.scanners.Scanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
public class DefaultKeywordParser
implements KeywordParser {
    private static final Logger logger = LoggerFactory.getLogger(DefaultKeywordParser.class);
    Map<String, Set<KeywordMethodEntity>> keywordMethods = new HashMap<String, Set<KeywordMethodEntity>>();
    Map<String, Set<Class<?>>> classRecord = new HashMap();

    @PostConstruct
    private void init() {
        logger.info("init keyValueParser");
        this.scanKeywordMethods();
    }

    private void scanKeywordMethods() {
        Reflections reflections = new Reflections(ContextServerConf.KEYWORD_SCAN_PACKAGE, new Scanner[]{new MethodAnnotationsScanner()});
        Set methods = reflections.getMethodsAnnotatedWith(KeywordMethod.class);
        for (Method method : methods) {
            method.setAccessible(true);
            KeywordMethod annotation = method.getAnnotation(KeywordMethod.class);
            KeywordMethodEntity keywordMethodEntity = new KeywordMethodEntity();
            keywordMethodEntity.setMethod(method);
            keywordMethodEntity.setRegex(annotation.regex());
            keywordMethodEntity.setSplitter(annotation.splitter());
            String className = method.getDeclaringClass().getName();
            if (!this.keywordMethods.containsKey(className)) {
                this.keywordMethods.put(className, new HashSet());
            }
            this.keywordMethods.get(className).add(keywordMethodEntity);
        }
    }

    private Set<String> parseKeywords(Object obj) throws Exception {
        Objects.requireNonNull(obj);
        HashSet<String> keywords = new HashSet<String>();
        String className = obj.getClass().getName();
        if (!this.classRecord.containsKey(className)) {
            this.classRecord.put(className, ReflectionUtils.getAllSuperTypes(obj.getClass(), (Predicate[])new Predicate[0]));
        }
        for (Class<?> clazz : this.classRecord.get(className)) {
            if (!this.keywordMethods.containsKey(clazz.getName())) continue;
            for (KeywordMethodEntity methodEntity : this.keywordMethods.get(clazz.getName())) {
                Object methodReturn = methodEntity.getMethod().invoke(obj, new Object[0]);
                if (null == methodReturn || StringUtils.isBlank((CharSequence)methodReturn.toString())) continue;
                if (StringUtils.isNotBlank((CharSequence)methodEntity.getSplitter())) {
                    Collections.addAll(keywords, methodReturn.toString().split(methodEntity.getSplitter()));
                    continue;
                }
                if (StringUtils.isNotBlank((CharSequence)methodEntity.getRegex())) {
                    keywords.addAll(this.getString(methodReturn.toString(), methodEntity.getRegex()));
                    continue;
                }
                keywords.add(methodReturn.toString());
            }
        }
        return keywords;
    }

    @Override
    public Set<String> parse(Object obj) {
        HashSet<String> keywords = new HashSet();
        try {
            keywords = this.parseKeywords(obj);
        }
        catch (Exception e) {
            logger.error("Failed to parse keywords ", (Throwable)e);
        }
        return keywords;
    }

    private Set<String> getString(String s, String regex) {
        HashSet<String> keywords = new HashSet<String>();
        Pattern p = Pattern.compile(regex);
        Matcher m = p.matcher(s);
        while (m.find()) {
            keywords.add(m.group());
        }
        return keywords;
    }
}

