/*
 * Decompiled with CFR 0.152.
 */
package org.apache.linkis.cs.execution.ruler;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.linkis.cs.common.entity.source.ContextKeyValue;
import org.apache.linkis.cs.execution.matcher.ContextSearchMatcher;
import org.apache.linkis.cs.execution.ruler.AbstractContextSearchRuler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommonListContextSearchRuler
extends AbstractContextSearchRuler {
    private static Logger logger = LoggerFactory.getLogger(CommonListContextSearchRuler.class);

    public CommonListContextSearchRuler(ContextSearchMatcher matcher) {
        super(matcher);
    }

    @Override
    public List<ContextKeyValue> rule(List<ContextKeyValue> contextKeyValues) {
        ArrayList filtered = Lists.newArrayList();
        if (CollectionUtils.isEmpty(contextKeyValues)) {
            logger.warn("Empty result fetched from cache.");
            return filtered;
        }
        int size = contextKeyValues.size();
        for (int i = 0; i < size; ++i) {
            ContextKeyValue contextKeyValue = contextKeyValues.get(i);
            if (!this.matcher.match(contextKeyValue).booleanValue()) continue;
            filtered.add(contextKeyValue);
        }
        return filtered;
    }
}

